/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.Entity;
import com.client.EntitySpotAnim;
import com.client.Model;
import com.client.Player;
import com.client.definitions.GraphicsDefinition;
import com.client.definitions.NpcDefinition;
import com.client.definitions.SeqDefinition;
import com.client.definitions.SeqFrame;
import com.client.features.settings.Preferences;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Map;
import net.runelite.api.Actor;
import net.runelite.api.ActorSpotAnim;
import net.runelite.api.IterableHashTable;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.rs.api.RSIterableNodeDeque;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSNPC;
import net.runelite.rs.api.RSNPCComposition;
import net.runelite.rs.api.RSNode;
import org.jetbrains.annotations.Nullable;

public final class Npc
extends Entity
implements RSNPC {
    public String customName = null;
    public int npcIndex = -1;
    public String displayName;
    public NpcDefinition definition;
    public int npcPetType;
    public NpcDefinition desc;
    public boolean deadnpc;
    private int index;

    private Model getAnimatedModel() {
        SeqDefinition primarySeq = null;
        SeqDefinition secondarySeq = null;
        if (this.primarySeqID >= 0 && this.primarySeqDelay == 0) {
            primarySeq = SeqDefinition.get(this.primarySeqID);
            boolean primarySeqIsSkeletal = primarySeq.isSkeletalAnimation();
            int primaryTransformID = primarySeqIsSkeletal ? -1 : primarySeq.getFrameIDs()[this.primarySeqFrame];
            int secondaryTransformID = -1;
            if (this.secondarySeqID >= 0 && this.secondarySeqID != this.seqStandID) {
                secondarySeq = SeqDefinition.get(this.secondarySeqID);
                boolean secondarySeqIsSkeletal = primarySeq.isSkeletalAnimation();
                int n = secondaryTransformID = secondarySeqIsSkeletal ? -1 : secondarySeq.getFrameIDs()[this.secondarySeqFrame];
            }
            if (primarySeq.isSkeletalAnimation() || secondarySeq != null && secondarySeq.isSkeletalAnimation()) {
                return this.desc.getAnimatedModelSkeletal(primarySeq, secondarySeq, this.primarySeqFrame, this.secondarySeqFrame);
            }
            return this.desc.getAnimatedModel(secondaryTransformID, primaryTransformID, SeqDefinition.get(this.primarySeqID).getMasks());
        }
        int transformID = -1;
        if (this.secondarySeqID >= 0) {
            secondarySeq = SeqDefinition.get(this.secondarySeqID);
            int n = transformID = secondarySeq.isSkeletalAnimation() ? -1 : secondarySeq.getFrameIDs()[this.secondarySeqFrame];
        }
        if (secondarySeq != null && secondarySeq.isSkeletalAnimation()) {
            return this.desc.getAnimatedModelSkeletal(primarySeq, secondarySeq, this.primarySeqFrame, this.secondarySeqFrame);
        }
        return this.desc.getAnimatedModel(-1, transformID, null);
    }

    @Override
    public Model getRotatedModel() {
        Map<Integer, Integer> enchantments;
        if (this.desc == null) {
            return null;
        }
        Model model = this.getAnimatedModel();
        if (model == null) {
            return null;
        }
        this.height = model.modelBaseY;
        if (this.npcIndex >= 0 && (enchantments = Client.instance.getEnchantmentsForNpc(this.npcIndex)) != null && !enchantments.isEmpty()) {
            int effectId = enchantments.keySet().iterator().next();
            int glowColor = effectId == 1 ? -103 : (effectId == 2 ? 8704 : -1);
            if (model.colors != null) {
                for (int i = 0; i < model.colors.length; ++i) {
                    int originalColor = model.colors[i] & 0xFFFF;
                    model.colors[i] = (short)this.blendColors(originalColor, glowColor, 0.15f);
                }
            }
        }
        for (EntitySpotAnim graphicObject : this.spotAnims) {
            if (graphicObject.getId() == -1) {
                graphicObject.remove();
                continue;
            }
            GraphicsDefinition spotAnim = GraphicsDefinition.cache[graphicObject.getId()];
            Model model_2 = spotAnim.getModel();
            if (model_2 == null) continue;
            SeqDefinition seq = spotAnim.animationSequence;
            Model model_3 = new Model(true, SeqFrame.noAnimationInProgress(graphicObject.getFrame()), false, model_2);
            model_3.offsetBy(0, -graphicObject.getHeight(), 0);
            if (graphicObject.getFrame() != -1) {
                if (seq != null && seq.isSkeletalAnimation()) {
                    model_3.playSkeletal(seq, graphicObject.getFrame());
                } else {
                    model_3.generateBones();
                    model_3.interpolate(spotAnim.animationSequence.frameIDs[graphicObject.getFrame()]);
                }
            }
            model_3.groupedTriangleLabels = null;
            model_3.groupedVertexLabels = null;
            if (spotAnim.resizeXY != 128 || spotAnim.resizeZ != 128) {
                model_3.scale(spotAnim.resizeXY, spotAnim.resizeXY, spotAnim.resizeZ);
            }
            model_3.light(64 + spotAnim.modelBrightness, 850 + spotAnim.modelShadow, -30, -50, -30, true);
            Model[] aclass30_sub2_sub4_sub6_1s = new Model[]{model, model_3};
            model = new Model(aclass30_sub2_sub4_sub6_1s);
        }
        if (this.desc.size == 1) {
            model.singleTile = true;
        }
        return model;
    }

    private int blendColors(int color1, int color2, float ratio) {
        int h1 = color1 >> 10 & 0x3F;
        int s1 = color1 >> 7 & 7;
        int l1 = color1 & 0x7F;
        int h2 = color2 >> 10 & 0x3F;
        int s2 = color2 >> 7 & 7;
        int l2 = color2 & 0x7F;
        int h3 = (int)((float)h1 + (float)(h2 - h1) * ratio);
        int s3 = (int)((float)s1 + (float)(s2 - s1) * ratio);
        int l = (int)((float)l1 + (float)(l2 - l1) * ratio);
        h3 = Math.max(0, Math.min(63, h3));
        s3 = Math.max(0, Math.min(7, s3));
        l = Math.max(0, Math.min(127, l));
        return h3 << 10 | s3 << 7 | l;
    }

    @Override
    public boolean isVisible() {
        if (Client.hidepets && this.desc != null && (this.npcPetType == 2 || this.npcPetType == 1)) {
            return false;
        }
        return this.desc != null;
    }

    Npc() {
    }

    public boolean isShowMenuOnHover() {
        return this.npcPetType == 0 || this.npcPetType == 2 && !Preferences.getPreferences().hidePetOptions;
    }

    @Override
    public int getCombatLevel() {
        return this.desc.getCombatLevel();
    }

    @Override
    @Nullable
    public NPCComposition getTransformedComposition() {
        return this.getComposition();
    }

    @Override
    public void onDefinitionChanged(NPCComposition composition) {
    }

    @Override
    public int getId() {
        return this.desc.getId();
    }

    @Override
    @Nullable
    public String getName() {
        return this.desc.getName();
    }

    @Override
    public Actor getInteracting() {
        int index = this.interactingEntity;
        if (index == -1 || index == 65535) {
            return null;
        }
        Client client = Client.instance;
        if (index < 32768) {
            RSNPC[] npcs = client.getCachedNPCs();
            return npcs[index];
        }
        Player[] players = client.players;
        return players[index -= 32768];
    }

    @Override
    public int getHealthRatio() {
        return Math.round(this.currentHealth / this.maxHealth);
    }

    @Override
    public int getHealthScale() {
        return 0;
    }

    @Override
    public WorldPoint getWorldLocation() {
        return WorldPoint.fromLocal(Client.instance, this.getLocalLocation());
    }

    @Override
    public LocalPoint getLocalLocation() {
        return new LocalPoint(this.getX(), this.getY());
    }

    @Override
    public void setIdleRotateLeft(int animationID) {
    }

    @Override
    public void setIdleRotateRight(int animationID) {
    }

    @Override
    public void setWalkAnimation(int animationID) {
    }

    @Override
    public void setWalkRotateLeft(int animationID) {
    }

    @Override
    public void setWalkRotateRight(int animationID) {
    }

    @Override
    public void setWalkRotate180(int animationID) {
    }

    @Override
    public void setRunAnimation(int animationID) {
    }

    @Override
    public Polygon getCanvasTilePoly() {
        byte size = this.desc.size;
        return Perspective.getCanvasTileAreaPoly(Client.instance, this.getLocalLocation(), size);
    }

    @Override
    @Nullable
    public Point getCanvasTextLocation(Graphics2D graphics, String text, int zOffset) {
        return Perspective.getCanvasTextLocation(Client.instance, graphics, this.getLocalLocation(), text, zOffset);
    }

    @Override
    public Point getCanvasImageLocation(BufferedImage image, int zOffset) {
        return Perspective.getCanvasImageLocation(Client.instance, this.getLocalLocation(), image, zOffset);
    }

    @Override
    public Point getCanvasSpriteLocation(SpritePixels sprite, int zOffset) {
        return null;
    }

    @Override
    public Point getMinimapLocation() {
        return Perspective.localToMinimap(Client.instance, this.getLocalLocation());
    }

    @Override
    public Shape getConvexHull() {
        RSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        int size = 1;
        LocalPoint localPoint = new LocalPoint(size * 64 - 64 + this.getX(), size * 64 - 64 + this.getY());
        int var4 = Perspective.getTileHeight(Client.instance, localPoint, Client.instance.getPlane());
        return model.getConvexHull(this.getX(), this.getY(), this.getOrientation(), var4);
    }

    @Override
    public WorldArea getWorldArea() {
        return new WorldArea(this.x, this.y, this.desc.size, this.height, Client.instance.getPlane());
    }

    @Override
    public boolean isDead() {
        return this.deadnpc;
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getRSInteracting() {
        return 0;
    }

    @Override
    public String getOverheadText() {
        return null;
    }

    @Override
    public void setOverheadText(String overheadText) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int[] getPathX() {
        return this.pathX;
    }

    @Override
    public int[] getPathY() {
        return this.pathY;
    }

    @Override
    public int getAnimation() {
        return this.primarySeqID;
    }

    @Override
    public void setAnimation(int animation) {
        this.primarySeqID = animation;
    }

    @Override
    public int getAnimationFrame() {
        return this.primarySeqFrame;
    }

    @Override
    public int getActionFrame() {
        return 0;
    }

    @Override
    public void setAnimationFrame(int frame) {
    }

    @Override
    public void setActionFrame(int frame) {
    }

    @Override
    public int getActionFrameCycle() {
        return 0;
    }

    @Override
    public int getGraphic() {
        return 0;
    }

    @Override
    public void setGraphic(int id) {
    }

    @Override
    public int getSpotAnimFrame() {
        return 0;
    }

    @Override
    public void setSpotAnimFrame(int id) {
    }

    @Override
    public int getSpotAnimationFrameCycle() {
        return 0;
    }

    @Override
    public int getIdlePoseAnimation() {
        return 0;
    }

    @Override
    public void setIdlePoseAnimation(int animation) {
    }

    @Override
    public int getPoseAnimation() {
        return 0;
    }

    @Override
    public void setPoseAnimation(int animation) {
    }

    @Override
    public int getPoseFrame() {
        return 0;
    }

    @Override
    public void setPoseFrame(int frame) {
    }

    @Override
    public int getPoseFrameCycle() {
        return 0;
    }

    @Override
    public int getLogicalHeight() {
        return Client.instance.getPlane();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public int getCurrentOrientation() {
        return this.orientation;
    }

    @Override
    public RSIterableNodeDeque getHealthBars() {
        return null;
    }

    @Override
    public int[] getHitsplatValues() {
        return new int[0];
    }

    @Override
    public int[] getHitsplatTypes() {
        return new int[0];
    }

    @Override
    public int[] getHitsplatCycles() {
        return new int[0];
    }

    @Override
    public int getIdleRotateLeft() {
        return 0;
    }

    @Override
    public int getIdleRotateRight() {
        return 0;
    }

    @Override
    public int getWalkAnimation() {
        return 0;
    }

    @Override
    public int getWalkRotate180() {
        return 0;
    }

    @Override
    public int getWalkRotateLeft() {
        return 0;
    }

    @Override
    public int getWalkRotateRight() {
        return 0;
    }

    @Override
    public int getRunAnimation() {
        return 0;
    }

    @Override
    public void setDead(boolean dead) {
        this.deadnpc = dead;
    }

    @Override
    public IterableHashTable<ActorSpotAnim> getSpotAnims() {
        return this.spotAnims;
    }

    @Override
    public boolean hasSpotAnim(int customGfxID) {
        for (EntitySpotAnim graphicObject : this.spotAnims) {
            if (graphicObject.getId() != customGfxID) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeSpotAnim(int hash) {
        Iterator ir = this.spotAnims.iterator();
        while (ir.hasNext()) {
            EntitySpotAnim graphicObject = (EntitySpotAnim)ir.next();
            if (graphicObject.getHash() != (long)hash) continue;
            graphicObject.remove();
            ir.remove();
        }
    }

    @Override
    public void createSpotAnim(int customGfxID, int customGfxID1, int i, int i1) {
        EntitySpotAnim entitySpotAnim = new EntitySpotAnim();
        entitySpotAnim.setId(customGfxID);
        entitySpotAnim.setHeight(i);
        entitySpotAnim.setCycle(Client.instance.getGameCycle() + i1);
        this.spotAnims.insert(entitySpotAnim, entitySpotAnim.getHash());
    }

    @Override
    public int getPathLength() {
        return 0;
    }

    @Override
    public int getOverheadCycle() {
        return 0;
    }

    @Override
    public void setOverheadCycle(int cycle) {
    }

    @Override
    public int getPoseAnimationFrame() {
        return 0;
    }

    @Override
    public void setPoseAnimationFrame(int frame) {
    }

    @Override
    public RSNPCComposition getComposition() {
        return this.desc;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int id) {
        this.index = id;
    }

    @Override
    public RSNode getNext() {
        return null;
    }

    @Override
    public long getHash() {
        return 0L;
    }

    @Override
    public RSNode getPrevious() {
        return null;
    }

    @Override
    public void onUnlink() {
    }

    @Override
    public int getModelHeight() {
        return 0;
    }

    @Override
    public void setModelHeight(int modelHeight) {
    }

    @Override
    public RSModel getModel() {
        return this.getRotatedModel();
    }

    @Override
    public void draw(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
    }
}

