/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.definitions.ItemDefinition;
import java.util.Arrays;

public class ItemSearch {
    private String itemSearchName;
    private int[] itemSearchResults;
    private int itemRange;
    private int itemSearchResultAmount;
    private boolean hideUntradables;

    public ItemSearch(String itemSearchName, int itemRange, boolean hideUntradables) {
        this.itemSearchName = itemSearchName;
        this.itemRange = itemRange;
        this.hideUntradables = hideUntradables;
        this.itemSearchResults = this.searchForName();
    }

    public int[] searchForName() {
        int[] items = new int[this.itemRange];
        int position = 0;
        for (int itemId = 0; itemId < ItemDefinition.totalItems; ++itemId) {
            String itemName;
            ItemDefinition itemDefinitions = ItemDefinition.lookup(itemId);
            if (position >= items.length) break;
            if (itemDefinitions == null || this.hideUntradables && !itemDefinitions.tradeable || (itemName = itemDefinitions.name) == null || !itemName.toLowerCase().contains(this.itemSearchName.toLowerCase()) || Arrays.binarySearch(items, itemId) >= 0) continue;
            items[position] = itemId;
            ++position;
            ++this.itemSearchResultAmount;
        }
        return items;
    }

    public int[] getItemSearchResults() {
        return this.itemSearchResults;
    }

    public int getItemSearchResultAmount() {
        return this.itemSearchResultAmount;
    }
}

