/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import one.util.streamex.IntStreamEx;

public class InputBuffer {
    public ByteBuf buffer;
    public int pos;
    public int bitPosition;
    private static final int[] BIT_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final char[] CHARACTERS = new char[]{'\u20ac', '\u0000', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u0000', '\u017d', '\u0000', '\u0000', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u0000', '\u017e', '\u0178'};

    public InputBuffer(byte[] data2) {
        this.buffer = Unpooled.wrappedBuffer(data2);
        this.pos = 0;
    }

    public InputBuffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public byte readSignedByte() {
        return this.buffer.readByte();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public int readSignedShort() {
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public int readSignedSmart() {
        int value = this.peek() & 0xFF;
        return value < 128 ? this.buffer.readUnsignedByte() - 64 : this.buffer.readUnsignedShort() - 49152;
    }

    public int readUnsignedSmart() {
        int value = this.peek() & 0xFF;
        return value < 128 ? this.buffer.readUnsignedByte() : this.buffer.readUnsignedShort() - 32768;
    }

    public int readBigSmart2() {
        if (this.peek() < 0) {
            return this.readInt() & Integer.MAX_VALUE;
        }
        int value = this.readUnsignedShort();
        return value == Short.MAX_VALUE ? -1 : value;
    }

    public int readUnsignedShortSmartMinusOne() {
        int peek = this.peek() & 0xFF;
        return peek < 128 ? this.readUnsignedByte() - 1 : this.readUnsignedShort() - 32769;
    }

    public int peek() {
        return this.buffer.getByte(this.buffer.readerIndex());
    }

    public int getPosition() {
        return this.buffer.readerIndex();
    }

    public void setPosition(int position) {
        this.buffer.readerIndex(position);
    }

    public void decrementPosition(int amount) {
        this.buffer.readerIndex(this.buffer.readerIndex() - amount);
    }

    public void incrementPosition(int amount) {
        this.buffer.readerIndex(this.buffer.readerIndex() + amount);
    }

    public byte[] getArray() {
        if (this.buffer.hasArray()) {
            return this.buffer.array();
        }
        byte[] array = new byte[this.buffer.readableBytes()];
        this.buffer.readBytes(array);
        return array;
    }

    public void disableBitAccess() {
        this.pos = (this.pos + 7) / 8;
    }

    public String readString() {
        return IntStreamEx.generate(this::readSignedByte).takeWhile(b -> b != 10).charsToString();
    }

    public String readStringOSRS2() {
        return IntStreamEx.generate(this::readUnsignedByte).takeWhile(b -> b != 0).map(b -> {
            if (b >= 128 && b < 160) {
                int c = CHARACTERS[b - 128];
                return c == 0 ? 63 : c;
            }
            return b;
        }).charsToString();
    }

    public String readStringOSRS() {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = this.readUnsignedByte()) != 0) {
            if (ch >= 128 && ch < 160) {
                int var7 = CHARACTERS[ch - 128];
                if (0 == var7) {
                    var7 = 63;
                }
                ch = var7;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public int readLEUShort() {
        this.pos += 2;
        return ((this.buffer.array()[this.pos - 1] & 0xFF) << 8) + (this.buffer.array()[this.pos - 2] & 0xFF);
    }

    public int readUShortA() {
        this.pos += 2;
        return ((this.buffer.array()[this.pos - 2] & 0xFF) << 8) + (this.buffer.array()[this.pos - 1] - 128 & 0xFF);
    }

    public void initBitAccess() {
        this.bitPosition = this.pos * 8;
    }

    public int readBits(int amount) {
        int byteOffset = this.pos >> 3;
        int bitOffset = 8 - (this.pos & 7);
        int value = 0;
        this.pos += amount;
        while (amount > bitOffset) {
            value += (this.buffer.array()[byteOffset++] & BIT_MASKS[bitOffset]) << amount - bitOffset;
            amount -= bitOffset;
            bitOffset = 8;
        }
        value = amount == bitOffset ? (value += this.buffer.array()[byteOffset] & BIT_MASKS[bitOffset]) : (value += this.buffer.array()[byteOffset] >> bitOffset - amount & BIT_MASKS[amount]);
        return value;
    }

    public int readLEUShortA() {
        this.pos += 2;
        return ((this.buffer.array()[this.pos - 1] & 0xFF) << 8) + (this.buffer.array()[this.pos - 2] - 128 & 0xFF);
    }

    public void writeByteS(int value) {
        this.buffer.array()[this.pos++] = (byte)(128 - value);
    }

    public int readNegUByte() {
        return -this.buffer.array()[this.pos++] & 0xFF;
    }

    public byte readByteS() {
        return (byte)(128 - this.buffer.array()[this.pos++]);
    }

    public int readMEInt() {
        this.pos += 4;
        return ((this.buffer.array()[this.pos - 2] & 0xFF) << 24) + ((this.buffer.array()[this.pos - 1] & 0xFF) << 16) + ((this.buffer.array()[this.pos - 4] & 0xFF) << 8) + (this.buffer.array()[this.pos - 3] & 0xFF);
    }

    public int readIMEInt() {
        this.pos += 4;
        return ((this.buffer.array()[this.pos - 3] & 0xFF) << 24) + ((this.buffer.array()[this.pos - 4] & 0xFF) << 16) + ((this.buffer.array()[this.pos - 1] & 0xFF) << 8) + (this.buffer.array()[this.pos - 2] & 0xFF);
    }

    public int readUSmart() {
        int peek = this.buffer.array()[this.pos] & 0xFF;
        return peek < 128 ? this.readUnsignedByte() : this.readUnsignedShort() - 32768;
    }

    public int readUByteA() {
        return this.buffer.array()[this.pos++] - 128 & 0xFF;
    }

    public int readLEShortA() {
        this.pos += 2;
        int value = ((this.buffer.array()[this.pos - 1] & 0xFF) << 8) + (this.buffer.array()[this.pos - 2] - 128 & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public byte[] getStringBytes() {
        return IntStreamEx.generate(this::readUnsignedByte).takeWhile(b -> b != 10).toByteArray();
    }

    public int read24BitInt() {
        return this.buffer.readUnsignedMedium();
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readIncrSmallSmart() {
        int current = 0;
        int read2 = this.readUnsignedSmart();
        while (read2 == Short.MAX_VALUE) {
            current += Short.MAX_VALUE;
            read2 = this.readUnsignedSmart();
        }
        return current += read2;
    }

    public int getLength() {
        return this.getArray().length;
    }

    public int getCapacity() {
        return this.buffer.capacity();
    }
}

