/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.RSImageProducer;
import com.client.Rasterizer2D;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public final class GraphicsBuffer {
    public final int[] canvasRaster;
    public final int canvasWidth;
    public final int canvasHeight;
    public BufferedImage bufferedImage;
    public final float[] depthBuffer;

    public void resetDepthBuffer() {
        if (this.depthBuffer == null) {
            return;
        }
        int length = this.depthBuffer.length;
        int loops = length - (length & 7);
        int position = 0;
        while (position < loops) {
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
            this.depthBuffer[position++] = 2.1474836E9f;
        }
        while (position < length) {
            this.depthBuffer[position++] = 2.1474836E9f;
        }
    }

    public GraphicsBuffer(int canvasWidth, int canvasHeight) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.bufferedImage = new BufferedImage(canvasWidth, canvasHeight, 1);
        this.canvasRaster = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        this.depthBuffer = new float[canvasWidth * canvasHeight];
        this.setCanvas();
    }

    public void drawGraphics(int x, Graphics graphics, int y) {
        RSImageProducer.drawScaledImage(this.bufferedImage, graphics, x, y, this.canvasWidth, this.canvasHeight);
    }

    public void setCanvas() {
        Rasterizer2D.initDrawingArea(this.canvasHeight, this.canvasWidth, this.canvasRaster);
    }
}

