/*
 * Decompiled with CFR 0.152.
 */
import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.runelite.client.RuneLite;

public class Application {
    public static void main(String[] args2) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long targetMemory = 0x80000000L;
        long currentMemoryMB = maxMemory / 1024L / 1024L;
        boolean use2GB = Application.showMemorySelectionDialog(currentMemoryMB);
        if (use2GB && maxMemory < targetMemory) {
            try {
                Application.restartWithMemoryOptimized(args2);
                return;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to restart with 2GB memory: " + e.getMessage(), "Error", 0);
                System.err.println("Failed to restart with 2GB memory: " + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            RuneLite.main(args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean showMemorySelectionDialog(long currentMemoryMB) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel titleLabel = new JLabel("RuneFury Client - Memory Configuration", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1, 16.0f));
        panel.add((Component)titleLabel, "North");
        long totalPhysicalMemory = 0L;
        try {
            totalPhysicalMemory = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        long systemMemoryGB = totalPhysicalMemory / 1024L / 1024L / 1024L;
        JPanel infoPanel = new JPanel(new GridLayout(5, 1, 5, 5));
        infoPanel.add(new JLabel("Current Memory Allocation: " + currentMemoryMB + "MB"));
        infoPanel.add(new JLabel("Recommended Memory: 2048MB (2GB)"));
        if (systemMemoryGB > 0L) {
            infoPanel.add(new JLabel("Your System RAM: " + systemMemoryGB + "GB"));
            if (systemMemoryGB < 4L) {
                infoPanel.add(new JLabel("\u26a0\ufe0f Low system RAM detected - optimizations will be applied"));
            } else {
                infoPanel.add(new JLabel("\u2713 System RAM adequate"));
            }
        }
        infoPanel.add(new JLabel("Would you like to restart with 2GB RAM for better performance?"));
        panel.add((Component)infoPanel, "Center");
        Object[] options = new String[]{"Yes, use 2GB RAM", "No, continue with " + currentMemoryMB + "MB"};
        int choice = JOptionPane.showOptionDialog(null, panel, "RuneFury - Memory Selection", 0, 3, null, options, options[0]);
        return choice == 0;
    }

    private static void restartWithMemoryOptimized(String[] args2) throws Exception {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String className = System.getProperty("sun.java.command");
        if (className == null || className.isEmpty()) {
            className = "Application";
        } else {
            String[] parts = className.split("\\s+");
            className = parts[0];
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command().add(javaBin);
        builder.command().add("-Xmx2048m");
        builder.command().add("-Xms512m");
        builder.command().add("-XX:MaxMetaspaceSize=256m");
        builder.command().add("-XX:CompressedClassSpaceSize=64m");
        builder.command().add("-XX:ReservedCodeCacheSize=128m");
        builder.command().add("-XX:+UseG1GC");
        builder.command().add("-XX:G1HeapRegionSize=16m");
        builder.command().add("-XX:MaxGCPauseMillis=100");
        builder.command().add("-XX:G1NewSizePercent=20");
        builder.command().add("-XX:G1MaxNewSizePercent=30");
        builder.command().add("-XX:InitiatingHeapOccupancyPercent=45");
        builder.command().add("-XX:+UseCompressedOops");
        builder.command().add("-XX:+UseCompressedClassPointers");
        builder.command().add("-XX:-UsePerfData");
        builder.command().add("-Djava.awt.headless=false");
        System.out.println("Applying low-RAM optimizations for systems with limited memory...");
        builder.command().add("-cp");
        builder.command().add(classpath);
        builder.command().add(className);
        for (String arg : args2) {
            builder.command().add(arg);
        }
        builder.inheritIO();
        System.out.println("Restarting with 2GB memory...");
        Process process = builder.start();
        System.exit(0);
    }
}

