/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;

public class ModelHash {
    public static final int TYPE_PLAYER = 0;
    public static final int TYPE_NPC = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_GROUND_ITEM = 3;
    private static final long SCENE_X_MASK = 127L;
    private static final long SCENE_Y_MASK = 16256L;
    private static final long TYPE_MASK = 49152L;
    private static final long ID_OR_INDEX_MASK = 562949953290240L;

    public static long pack(int id_or_index, boolean bool, int type, int sceneY, int sceneX) {
        return ((long)id_or_index & 0xFFFFFFFFL) << 17 | (bool ? 1L : 0L) << 16 | ((long)type & 3L) << 14 | (long)((sceneY & 0x7F) << 7) | (long)(sceneX & 0x7F);
    }

    public static int getSceneX(long hash) {
        return (int)(hash & 0x7FL);
    }

    public static int getSceneY(long hash) {
        return (int)((hash & 0x3F80L) >> 7);
    }

    public static int getType(long hash) {
        return (int)((hash & 0xC000L) >> 14);
    }

    public static int getIdOrIndex(long hash) {
        return (int)((hash & 0x1FFFFFFFE0000L) >>> 17);
    }

    public static long getUuid(Client client, long hash) {
        int idOrIndex;
        int type = ModelHash.getType(hash);
        int id = idOrIndex = ModelHash.getIdOrIndex(hash);
        if (type == 1) {
            NPC npc;
            id = -1;
            NPC[] npcs = client.getCachedNPCs();
            if (idOrIndex >= 0 && idOrIndex < npcs.length && (npc = npcs[idOrIndex]) != null) {
                id = npcs[idOrIndex].getId();
            }
        }
        return ModelHash.packUuid(id, type);
    }

    public static long packUuid(int id, int type) {
        return ModelHash.pack(id, false, type, 0, 0);
    }

    public static WorldPoint getWorldLocation(Client client, int x, int z) {
        return WorldPoint.fromScene(client, (x + client.getCameraX2()) / 128, (z + client.getCameraZ2()) / 128, 0);
    }
}

