/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.runelite.api.coords.WorldPoint;

public class AABB {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public AABB(int x, int y) {
        this.minX = this.maxX = x;
        this.minY = this.maxY = y;
        this.minZ = Integer.MIN_VALUE;
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x, int y, int z) {
        this.minX = this.maxX = x;
        this.minY = this.maxY = y;
        this.minZ = this.maxZ = z;
    }

    public AABB(int x1, int y1, int x2, int y2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Integer.MIN_VALUE;
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x1, int y1, int x2, int y2, int z1) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.minZ = this.maxZ = z1;
    }

    public AABB(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public static AABB parse(int ... ints) {
        switch (ints.length) {
            case 2: {
                return new AABB(ints[0], ints[1]);
            }
            case 3: {
                return new AABB(ints[0], ints[1], ints[2]);
            }
            case 4: {
                return new AABB(ints[0], ints[1], ints[2], ints[3]);
            }
            case 5: {
                return new AABB(ints[0], ints[2], ints[1], ints[3], ints[4]);
            }
            case 6: {
                return new AABB(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5]);
            }
        }
        throw new IllegalArgumentException("AABB must be one of: (x,y), (x,y,z), (x1,y1,x2,y2), (x1,y1,x2,y2,z), (x1,y1,x2,y2,z1,z2)");
    }

    public boolean hasZ() {
        return this.minZ != Integer.MIN_VALUE || this.maxZ != Integer.MAX_VALUE;
    }

    public boolean isPoint() {
        return this.minX == this.maxX && this.minY == this.maxY && (!this.hasZ() || this.minZ == this.maxZ);
    }

    public boolean isVolume() {
        return !this.isPoint();
    }

    public boolean contains(int x, int y) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
    }

    public boolean contains(int x, int y, int z) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.maxZ;
    }

    public boolean contains(WorldPoint location) {
        return this.contains(location.getX(), location.getY(), location.getPlane());
    }

    public boolean intersects(int minX, int minY, int maxX, int maxY) {
        return minX <= this.maxX && maxX >= this.minX && minY <= this.maxY && maxY >= this.minY;
    }

    public boolean intersects(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return minX <= this.maxX && maxX >= this.minX && minY <= this.maxY && maxY >= this.minY && minZ <= this.maxZ && maxZ >= this.minZ;
    }

    public boolean intersects(AABB other) {
        return this.intersects(other.minX, other.maxX, other.minY, other.maxY, other.minZ, other.maxZ);
    }

    public String toString() {
        if (this.hasZ()) {
            return String.format("AABB{min=(%d,%d,%d), max=(%d,%d,%d)}", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return String.format("AABB{min=(%d,%d), max=(%d,%d)}", this.minX, this.minY, this.maxX, this.maxY);
    }

    public static class JsonAdapter
    extends TypeAdapter<AABB[]> {
        @Override
        public AABB[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<AABB> list = new ArrayList<AABB>();
            while (in.hasNext() && in.peek() != JsonToken.END_ARRAY) {
                if (in.peek() == JsonToken.NULL) {
                    in.skipValue();
                    continue;
                }
                in.beginArray();
                int[] ints = new int[6];
                int i = 0;
                block13: while (in.hasNext()) {
                    switch (in.peek()) {
                        case NUMBER: {
                            if (i >= ints.length) {
                                throw new IOException("Too many numbers in AABB entry. Must be less than " + ints.length + ".");
                            }
                            ints[i++] = in.nextInt();
                        }
                        case END_ARRAY: {
                            continue block13;
                        }
                        case NULL: {
                            in.skipValue();
                            continue block13;
                        }
                    }
                    throw new IOException("Malformed AABB entry. Unexpected token: " + String.valueOf((Object)in.peek()));
                }
                in.endArray();
                switch (i) {
                    case 2: {
                        list.add(new AABB(ints[0], ints[1]));
                        break;
                    }
                    case 3: {
                        list.add(new AABB(ints[0], ints[1], ints[2]));
                        break;
                    }
                    case 4: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3]));
                        break;
                    }
                    case 5: {
                        list.add(new AABB(ints[0], ints[2], ints[1], ints[3], ints[4]));
                        break;
                    }
                    case 6: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5]));
                    }
                }
            }
            in.endArray();
            return list.toArray(new AABB[0]);
        }

        @Override
        public void write(JsonWriter out, AABB[] aabbs) throws IOException {
            if (aabbs == null || aabbs.length == 0) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (AABB aabb : aabbs) {
                out.beginArray();
                out.value(aabb.minX);
                out.value(aabb.minY);
                if (aabb.hasZ()) {
                    out.value(aabb.minZ);
                }
                if (aabb.isVolume()) {
                    out.value(aabb.maxX);
                    out.value(aabb.maxY);
                    if (aabb.hasZ()) {
                        out.value(aabb.maxZ);
                    }
                }
                out.endArray();
            }
            out.endArray();
        }
    }
}

