/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import com.google.common.base.Stopwatch;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.data.WaterType;
import rs117.hd.data.materials.GroundMaterial;
import rs117.hd.data.materials.Material;
import rs117.hd.data.materials.Overlay;
import rs117.hd.data.materials.Underlay;
import rs117.hd.model.ModelPusher;
import rs117.hd.scene.ModelOverrideManager;
import rs117.hd.scene.ProceduralGenerator;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.scene.model_overrides.ObjectType;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.buffer.GpuFloatBuffer;
import rs117.hd.utils.buffer.GpuIntBuffer;

@Singleton
public class SceneUploader {
    private static final Logger log = LoggerFactory.getLogger(SceneUploader.class);
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    public ProceduralGenerator proceduralGenerator;
    @Inject
    private ModelPusher modelPusher;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    public int sceneId = new Random().nextInt();
    private int offset;
    private int uvOffset;
    private final float[] UP_NORMAL = new float[]{0.0f, -1.0f, 0.0f};

    public void upload(Scene scene, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ++this.sceneId;
        this.offset = 0;
        this.uvOffset = 0;
        vertexBuffer.clear();
        uvBuffer.clear();
        normalBuffer.clear();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    Tile tile = scene.getTiles()[z][x][y];
                    if (tile == null) continue;
                    this.upload(tile, vertexBuffer, uvBuffer, normalBuffer);
                }
            }
        }
        stopwatch.stop();
        log.debug("Scene upload time: {}", (Object)stopwatch);
    }

    private void uploadModel(long hash, Model model, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer, int tileZ, int tileX, int tileY, ObjectType objectType) {
        if (model.getSceneId() == this.sceneId) {
            return;
        }
        ModelOverride modelOverride = this.modelOverrideManager.getOverride(hash);
        int skipObject = 0;
        if (this.client.getBaseX() + tileX == 2558 && this.client.getBaseY() + tileY >= 3249 && this.client.getBaseY() + tileY <= 3252) {
            skipObject = 3;
        }
        model.setBufferOffset(this.offset << 2 | skipObject);
        if (model.getFaceTextures() != null || this.plugin.configModelTextures && modelOverride.baseMaterial != Material.NONE) {
            model.setUvBufferOffset(this.uvOffset);
        } else {
            model.setUvBufferOffset(-1);
        }
        model.setSceneId(this.sceneId);
        int[] lengths = this.modelPusher.pushModel(hash, model, vertexBuffer, uvBuffer, normalBuffer, tileX, tileY, tileZ, modelOverride, objectType, true);
        this.offset += lengths[0];
        this.uvOffset += lengths[1];
    }

    private void upload(Tile tile, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        Renderable renderable;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.upload(bridge, vertexBuffer, uvBuffer, normalBuffer);
        }
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        SceneTilePaint sceneTilePaint = tile.getSceneTilePaint();
        if (sceneTilePaint != null) {
            int[] uploadedTilePaintData = this.upload(tile, sceneTilePaint, tileZ, tileX, tileY, vertexBuffer, uvBuffer, normalBuffer);
            int bufferLength = uploadedTilePaintData[0];
            int uvBufferLength = uploadedTilePaintData[1];
            int underwaterTerrain = uploadedTilePaintData[2];
            int packedBufferLength = bufferLength << 1 | underwaterTerrain;
            sceneTilePaint.setBufferOffset(this.offset);
            sceneTilePaint.setUvBufferOffset(uvBufferLength > 0 ? this.uvOffset : -1);
            sceneTilePaint.setBufferLen(packedBufferLength);
            this.offset += bufferLength;
            this.uvOffset += uvBufferLength;
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            int[] uploadedTileModelData = this.upload(tile, sceneTileModel, tileZ, tileX, tileY, vertexBuffer, uvBuffer, normalBuffer);
            int bufferLength = uploadedTileModelData[0];
            int uvBufferLength = uploadedTileModelData[1];
            int underwaterTerrain = uploadedTileModelData[2];
            int packedBufferLength = bufferLength << 1 | underwaterTerrain;
            sceneTileModel.setBufferOffset(this.offset);
            sceneTileModel.setUvBufferOffset(uvBufferLength > 0 ? this.uvOffset : -1);
            sceneTileModel.setBufferLen(packedBufferLength);
            this.offset += bufferLength;
            this.uvOffset += uvBufferLength;
        }
        if ((wallObject = tile.getWallObject()) != null) {
            Renderable renderable2;
            Renderable renderable1 = wallObject.getRenderable1();
            if (renderable1 instanceof Model) {
                this.uploadModel(wallObject.getHash(), (Model)renderable1, vertexBuffer, uvBuffer, normalBuffer, tileZ, tileX, tileY, ObjectType.WALL_OBJECT);
            }
            if ((renderable2 = wallObject.getRenderable2()) instanceof Model) {
                this.uploadModel(wallObject.getHash(), (Model)renderable2, vertexBuffer, uvBuffer, normalBuffer, tileZ, tileX, tileY, ObjectType.WALL_OBJECT);
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && (renderable = groundObject.getRenderable()) instanceof Model) {
            this.uploadModel(groundObject.getHash(), (Model)renderable, vertexBuffer, uvBuffer, normalBuffer, tileZ, tileX, tileY, ObjectType.GROUND_OBJECT);
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null) {
            Renderable renderable2;
            Renderable renderable3 = decorativeObject.getRenderable();
            if (renderable3 instanceof Model) {
                this.uploadModel(decorativeObject.getHash(), (Model)renderable3, vertexBuffer, uvBuffer, normalBuffer, tileZ, tileX, tileY, ObjectType.DECORATIVE_OBJECT);
            }
            if ((renderable2 = decorativeObject.getRenderable2()) instanceof Model) {
                this.uploadModel(decorativeObject.getHash(), (Model)renderable2, vertexBuffer, uvBuffer, normalBuffer, tileZ, tileX, tileY, ObjectType.DECORATIVE_OBJECT);
            }
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            Renderable renderable4;
            if (gameObject == null || !((renderable4 = gameObject.getRenderable()) instanceof Model)) continue;
            this.uploadModel(gameObject.getHash(), (Model)gameObject.getRenderable(), vertexBuffer, uvBuffer, normalBuffer, tileZ, tileX, tileY, ObjectType.GAME_OBJECT);
        }
    }

    int[] upload(Tile tile, SceneTilePaint sceneTilePaint, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTilePaintSurface(tile, sceneTilePaint, tileZ, tileX, tileY, vertexBuffer, uvBuffer, normalBuffer);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTilePaintUnderwater(tile, sceneTilePaint, tileZ, tileX, tileY, vertexBuffer, uvBuffer, normalBuffer);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    int[] uploadHDTilePaintSurface(Tile tile, SceneTilePaint sceneTilePaint, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        boolean localX = false;
        boolean localY = false;
        int baseX = this.client.getBaseX();
        int baseY = this.client.getBaseY();
        int[][][] tileHeights = this.client.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int localSwVertexX = 0;
        int localSwVertexY = 0;
        int localSeVertexX = 128;
        int localSeVertexY = 0;
        int localNwVertexX = 0;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = this.proceduralGenerator.tileVertexKeys(tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (sceneTilePaint.getNeColor() != 12345678) {
            int swColor = sceneTilePaint.getSwColor();
            int seColor = sceneTilePaint.getSeColor();
            int neColor = sceneTilePaint.getNeColor();
            int nwColor = sceneTilePaint.getNwColor();
            int tileTexture = sceneTilePaint.getTexture();
            boolean neVertexIsOverlay = false;
            boolean nwVertexIsOverlay = false;
            boolean seVertexIsOverlay = false;
            boolean swVertexIsOverlay = false;
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            float[] swNormals = this.UP_NORMAL;
            float[] seNormals = this.UP_NORMAL;
            float[] neNormals = this.UP_NORMAL;
            float[] nwNormals = this.UP_NORMAL;
            WaterType waterType = this.proceduralGenerator.tileWaterType(tile, sceneTilePaint);
            if (waterType == WaterType.NONE) {
                swMaterial = Material.getTexture(tileTexture);
                seMaterial = Material.getTexture(tileTexture);
                neMaterial = Material.getTexture(tileTexture);
                nwMaterial = Material.getTexture(tileTexture);
                swNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(swVertexKey, swNormals);
                seNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(seVertexKey, seNormals);
                neNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(neVertexKey, neNormals);
                nwNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(nwVertexKey, nwNormals);
                if (this.proceduralGenerator.vertexIsWater.containsKey(swVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(swVertexKey)) {
                    swColor = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(seVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(seVertexKey)) {
                    seColor = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(nwVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(nwVertexKey)) {
                    nwColor = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(neVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(neVertexKey)) {
                    neColor = 0;
                }
                if (this.plugin.configGroundBlending && !this.proceduralGenerator.useDefaultColor(tile) && sceneTilePaint.getTexture() == -1) {
                    swColor = this.proceduralGenerator.vertexTerrainColor.getOrDefault(swVertexKey, swColor);
                    seColor = this.proceduralGenerator.vertexTerrainColor.getOrDefault(seVertexKey, seColor);
                    neColor = this.proceduralGenerator.vertexTerrainColor.getOrDefault(neVertexKey, neColor);
                    nwColor = this.proceduralGenerator.vertexTerrainColor.getOrDefault(nwVertexKey, nwColor);
                    if (this.plugin.configGroundTextures) {
                        swMaterial = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(swVertexKey, swMaterial);
                        seMaterial = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(seVertexKey, seMaterial);
                        neMaterial = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(neVertexKey, neMaterial);
                        nwMaterial = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(nwVertexKey, nwMaterial);
                    }
                } else if (this.plugin.configGroundTextures && !this.shouldSkipTile(baseX + tileX, baseY + tileY)) {
                    GroundMaterial groundMaterial;
                    Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                    if (overlay != Overlay.NONE) {
                        groundMaterial = overlay.groundMaterial;
                        swColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(neColor)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        groundMaterial = underlay.groundMaterial;
                        swColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(neColor)));
                    }
                    swMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY);
                    seMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY);
                    nwMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY + 1);
                    neMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY + 1);
                } else if (this.plugin.configWinterTheme) {
                    Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                    if (overlay != Overlay.NONE) {
                        swColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(neColor)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        swColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(swColor)));
                        seColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(seColor)));
                        nwColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(nwColor)));
                        neColor = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(neColor)));
                    }
                }
            } else {
                neColor = 127;
                nwColor = 127;
                seColor = 127;
                swColor = 127;
                if (this.proceduralGenerator.vertexIsWater.containsKey(swVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(swVertexKey)) {
                    swColor = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(seVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(seVertexKey)) {
                    seColor = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(nwVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(nwVertexKey)) {
                    nwColor = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(neVertexKey) && this.proceduralGenerator.vertexIsLand.containsKey(neVertexKey)) {
                    neColor = 0;
                }
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(neVertexKey) && this.proceduralGenerator.vertexIsUnderlay.containsKey(neVertexKey)) {
                neVertexIsOverlay = true;
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(nwVertexKey) && this.proceduralGenerator.vertexIsUnderlay.containsKey(nwVertexKey)) {
                nwVertexIsOverlay = true;
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(seVertexKey) && this.proceduralGenerator.vertexIsUnderlay.containsKey(seVertexKey)) {
                seVertexIsOverlay = true;
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(swVertexKey) && this.proceduralGenerator.vertexIsUnderlay.containsKey(swVertexKey)) {
                swVertexIsOverlay = true;
            }
            int swTerrainData = this.packTerrainData(0, waterType, tileZ);
            int seTerrainData = this.packTerrainData(0, waterType, tileZ);
            int nwTerrainData = this.packTerrainData(0, waterType, tileZ);
            int neTerrainData = this.packTerrainData(0, waterType, tileZ);
            normalBuffer.ensureCapacity(24);
            normalBuffer.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            normalBuffer.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            normalBuffer.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            normalBuffer.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            normalBuffer.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            normalBuffer.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            vertexBuffer.ensureCapacity(24);
            vertexBuffer.put(localNeVertexX, neHeight, localNeVertexY, neColor);
            vertexBuffer.put(localNwVertexX, nwHeight, localNwVertexY, nwColor);
            vertexBuffer.put(localSeVertexX, seHeight, localSeVertexY, seColor);
            vertexBuffer.put(localSwVertexX, swHeight, localSwVertexY, swColor);
            vertexBuffer.put(localSeVertexX, seHeight, localSeVertexY, seColor);
            vertexBuffer.put(localNwVertexX, nwHeight, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, swVertexIsOverlay);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, seVertexIsOverlay);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, nwVertexIsOverlay);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, neVertexIsOverlay);
            uvBuffer.ensureCapacity(24);
            uvBuffer.put(packedMaterialDataNE, 1.0f, 1.0f, 0.0f);
            uvBuffer.put(packedMaterialDataNW, 0.0f, 1.0f, 0.0f);
            uvBuffer.put(packedMaterialDataSE, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(packedMaterialDataSW, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(packedMaterialDataSE, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(packedMaterialDataNW, 0.0f, 1.0f, 0.0f);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    int[] uploadHDTilePaintUnderwater(Tile tile, SceneTilePaint sceneTilePaint, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        int baseX = this.client.getBaseX();
        int baseY = this.client.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{0, 0, 0};
        }
        int[][][] tileHeights = this.client.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int localSwVertexX = 0;
        int localSwVertexY = 0;
        int localSeVertexX = 128;
        int localSeVertexY = 0;
        int localNwVertexX = 0;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = this.proceduralGenerator.tileVertexKeys(tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (this.proceduralGenerator.tileIsWater[tileZ][tileX][tileY]) {
            underwaterTerrain = 1;
            int swColor = 6676;
            int seColor = 6676;
            int neColor = 6676;
            int nwColor = 6676;
            int swDepth = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(swVertexKey, 0);
            int seDepth = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(seVertexKey, 0);
            int nwDepth = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(nwVertexKey, 0);
            int neDepth = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(neVertexKey, 0);
            float[] swNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(swVertexKey, this.UP_NORMAL);
            float[] seNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(seVertexKey, this.UP_NORMAL);
            float[] nwNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(nwVertexKey, this.UP_NORMAL);
            float[] neNormals = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(neVertexKey, this.UP_NORMAL);
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            if (this.plugin.configGroundTextures) {
                GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                swMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY);
                seMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY);
                nwMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY + 1);
                neMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY + 1);
            }
            WaterType waterType = this.proceduralGenerator.tileWaterType(tile, sceneTilePaint);
            int swTerrainData = this.packTerrainData(Math.max(1, swDepth), waterType, tileZ);
            int seTerrainData = this.packTerrainData(Math.max(1, seDepth), waterType, tileZ);
            int nwTerrainData = this.packTerrainData(Math.max(1, nwDepth), waterType, tileZ);
            int neTerrainData = this.packTerrainData(Math.max(1, neDepth), waterType, tileZ);
            normalBuffer.ensureCapacity(24);
            normalBuffer.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            normalBuffer.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            normalBuffer.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            normalBuffer.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            normalBuffer.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            normalBuffer.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            vertexBuffer.ensureCapacity(24);
            vertexBuffer.put(localNeVertexX, neHeight + neDepth, localNeVertexY, neColor);
            vertexBuffer.put(localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            vertexBuffer.put(localSeVertexX, seHeight + seDepth, localSeVertexY, seColor);
            vertexBuffer.put(localSwVertexX, swHeight + swDepth, localSwVertexY, swColor);
            vertexBuffer.put(localSeVertexX, seHeight + seDepth, localSeVertexY, seColor);
            vertexBuffer.put(localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, false);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, false);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, false);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, false);
            uvBuffer.ensureCapacity(24);
            uvBuffer.put(packedMaterialDataNE, 1.0f, 1.0f, 0.0f);
            uvBuffer.put(packedMaterialDataNW, 0.0f, 1.0f, 0.0f);
            uvBuffer.put(packedMaterialDataSE, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(packedMaterialDataSW, 0.0f, 0.0f, 0.0f);
            uvBuffer.put(packedMaterialDataSE, 1.0f, 0.0f, 0.0f);
            uvBuffer.put(packedMaterialDataNW, 0.0f, 1.0f, 0.0f);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    int[] upload(Tile tile, SceneTileModel sceneTileModel, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTileModelSurface(tile, sceneTileModel, tileZ, tileX, tileY, vertexBuffer, uvBuffer, normalBuffer);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTileModelUnderwater(tile, sceneTileModel, tileZ, tileX, tileY, vertexBuffer, uvBuffer, normalBuffer);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    int[] uploadHDTileModelSurface(Tile tile, SceneTileModel sceneTileModel, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (this.proceduralGenerator.skipTile[tileZ][tileX][tileY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = sceneTileModel.getTriangleColorA();
        int[] faceColorB = sceneTileModel.getTriangleColorB();
        int[] faceColorC = sceneTileModel.getTriangleColorC();
        int[] faceTextures = sceneTileModel.getTriangleTextureId();
        int faceCount = sceneTileModel.getFaceX().length;
        int baseX = this.client.getBaseX();
        int baseY = this.client.getBaseY();
        for (int face = 0; face < faceCount; ++face) {
            int colorA = faceColorA[face];
            int colorB = faceColorB[face];
            int colorC = faceColorC[face];
            if (colorA == 12345678) continue;
            int[][] localVertices = this.proceduralGenerator.faceLocalVertices(tile, face);
            int[] vertexKeys = this.proceduralGenerator.faceVertexKeys(tile, face);
            int vertexKeyA = vertexKeys[0];
            int vertexKeyB = vertexKeys[1];
            int vertexKeyC = vertexKeys[2];
            boolean vertexAIsOverlay = false;
            boolean vertexBIsOverlay = false;
            boolean vertexCIsOverlay = false;
            Material materialA = Material.NONE;
            Material materialB = Material.NONE;
            Material materialC = Material.NONE;
            float[] normalsA = this.UP_NORMAL;
            float[] normalsB = this.UP_NORMAL;
            float[] normalsC = this.UP_NORMAL;
            WaterType waterType = this.proceduralGenerator.faceWaterType(tile, face, sceneTileModel);
            if (waterType == WaterType.NONE) {
                if (faceTextures != null) {
                    materialA = Material.getTexture(faceTextures[face]);
                    materialB = Material.getTexture(faceTextures[face]);
                    materialC = Material.getTexture(faceTextures[face]);
                }
                normalsA = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(vertexKeyA, normalsA);
                normalsB = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(vertexKeyB, normalsB);
                normalsC = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(vertexKeyC, normalsC);
                if (!(!this.plugin.configGroundBlending || this.proceduralGenerator.isOverlayFace(tile, face) && this.proceduralGenerator.useDefaultColor(tile) || materialA != Material.NONE)) {
                    colorA = this.proceduralGenerator.vertexTerrainColor.getOrDefault(vertexKeyA, colorA);
                    colorB = this.proceduralGenerator.vertexTerrainColor.getOrDefault(vertexKeyB, colorB);
                    colorC = this.proceduralGenerator.vertexTerrainColor.getOrDefault(vertexKeyC, colorC);
                    if (this.plugin.configGroundTextures) {
                        materialA = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(vertexKeyA, materialA);
                        materialB = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(vertexKeyB, materialB);
                        materialC = this.proceduralGenerator.vertexTerrainTexture.getOrDefault(vertexKeyC, materialC);
                    }
                } else if (this.plugin.configGroundTextures) {
                    GroundMaterial groundMaterial;
                    if (this.proceduralGenerator.isOverlayFace(tile, face)) {
                        Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        groundMaterial = overlay.groundMaterial;
                        colorA = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(colorC)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        groundMaterial = underlay.groundMaterial;
                        colorA = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(colorC)));
                    }
                    materialA = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[0][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[0][1] / 128.0f));
                    materialB = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[1][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[1][1] / 128.0f));
                    materialC = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[2][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[2][1] / 128.0f));
                } else if (this.plugin.configWinterTheme) {
                    if (this.proceduralGenerator.isOverlayFace(tile, face)) {
                        Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        colorA = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorOverlay(overlay, HDUtils.colorIntToHSL(colorC)));
                    } else {
                        Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        colorA = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(colorA)));
                        colorB = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(colorB)));
                        colorC = HDUtils.colorHSLToInt(this.proceduralGenerator.recolorUnderlay(underlay, HDUtils.colorIntToHSL(colorC)));
                    }
                }
            } else {
                colorC = 127;
                colorB = 127;
                colorA = 127;
                if (this.proceduralGenerator.vertexIsWater.containsKey(vertexKeyA) && this.proceduralGenerator.vertexIsLand.containsKey(vertexKeyA)) {
                    colorA = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(vertexKeyB) && this.proceduralGenerator.vertexIsLand.containsKey(vertexKeyB)) {
                    colorB = 0;
                }
                if (this.proceduralGenerator.vertexIsWater.containsKey(vertexKeyC) && this.proceduralGenerator.vertexIsLand.containsKey(vertexKeyC)) {
                    colorC = 0;
                }
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(vertexKeyA) && this.proceduralGenerator.vertexIsUnderlay.containsKey(vertexKeyA)) {
                vertexAIsOverlay = true;
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(vertexKeyB) && this.proceduralGenerator.vertexIsUnderlay.containsKey(vertexKeyB)) {
                vertexBIsOverlay = true;
            }
            if (this.proceduralGenerator.vertexIsOverlay.containsKey(vertexKeyC) && this.proceduralGenerator.vertexIsUnderlay.containsKey(vertexKeyC)) {
                vertexCIsOverlay = true;
            }
            int aTerrainData = this.packTerrainData(0, waterType, tileZ);
            int bTerrainData = this.packTerrainData(0, waterType, tileZ);
            int cTerrainData = this.packTerrainData(0, waterType, tileZ);
            normalBuffer.ensureCapacity(12);
            normalBuffer.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
            normalBuffer.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
            normalBuffer.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
            vertexBuffer.ensureCapacity(12);
            vertexBuffer.put(localVertices[0][0], localVertices[0][2], localVertices[0][1], colorA);
            vertexBuffer.put(localVertices[1][0], localVertices[1][2], localVertices[1][1], colorB);
            vertexBuffer.put(localVertices[2][0], localVertices[2][2], localVertices[2][1], colorC);
            bufferLength += 3;
            int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, vertexAIsOverlay);
            int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, vertexBIsOverlay);
            int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, vertexCIsOverlay);
            uvBuffer.ensureCapacity(12);
            uvBuffer.put(packedMaterialDataA, (float)localVertices[0][0] / 128.0f, (float)localVertices[0][1] / 128.0f, 0.0f);
            uvBuffer.put(packedMaterialDataB, (float)localVertices[1][0] / 128.0f, (float)localVertices[1][1] / 128.0f, 0.0f);
            uvBuffer.put(packedMaterialDataC, (float)localVertices[2][0] / 128.0f, (float)localVertices[2][1] / 128.0f, 0.0f);
            uvBufferLength += 3;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    int[] uploadHDTileModelUnderwater(Tile tile, SceneTileModel sceneTileModel, int tileZ, int tileX, int tileY, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (this.proceduralGenerator.skipTile[tileZ][tileX][tileY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = sceneTileModel.getTriangleColorA();
        int faceCount = sceneTileModel.getFaceX().length;
        int baseX = this.client.getBaseX();
        int baseY = this.client.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        if (this.proceduralGenerator.tileIsWater[tileZ][tileX][tileY]) {
            underwaterTerrain = 1;
            for (int face = 0; face < faceCount; ++face) {
                int colorA = 6676;
                int colorB = 6676;
                int colorC = 6676;
                if (faceColorA[face] == 12345678) continue;
                int[][] localVertices = this.proceduralGenerator.faceLocalVertices(tile, face);
                Material materialA = Material.NONE;
                Material materialB = Material.NONE;
                Material materialC = Material.NONE;
                int[] vertexKeys = this.proceduralGenerator.faceVertexKeys(tile, face);
                int vertexKeyA = vertexKeys[0];
                int vertexKeyB = vertexKeys[1];
                int vertexKeyC = vertexKeys[2];
                int depthA = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(vertexKeyA, 0);
                int depthB = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(vertexKeyB, 0);
                int depthC = this.proceduralGenerator.vertexUnderwaterDepth.getOrDefault(vertexKeyC, 0);
                if (this.plugin.configGroundTextures) {
                    GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                    int tileVertexX = Math.round((float)localVertices[0][0] / 128.0f) + tileX + baseX;
                    int tileVertexY = Math.round((float)localVertices[0][1] / 128.0f) + tileY + baseY;
                    materialA = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                    tileVertexX = Math.round((float)localVertices[1][0] / 128.0f) + tileX + baseX;
                    tileVertexY = Math.round((float)localVertices[1][1] / 128.0f) + tileY + baseY;
                    materialB = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                    tileVertexX = Math.round((float)localVertices[2][0] / 128.0f) + tileX + baseX;
                    tileVertexY = Math.round((float)localVertices[2][1] / 128.0f) + tileY + baseY;
                    materialC = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                }
                float[] normalsA = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(vertexKeyA, this.UP_NORMAL);
                float[] normalsB = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(vertexKeyB, this.UP_NORMAL);
                float[] normalsC = this.proceduralGenerator.vertexTerrainNormals.getOrDefault(vertexKeyC, this.UP_NORMAL);
                WaterType waterType = this.proceduralGenerator.faceWaterType(tile, face, sceneTileModel);
                int aTerrainData = this.packTerrainData(Math.max(1, depthA), waterType, tileZ);
                int bTerrainData = this.packTerrainData(Math.max(1, depthB), waterType, tileZ);
                int cTerrainData = this.packTerrainData(Math.max(1, depthC), waterType, tileZ);
                normalBuffer.ensureCapacity(12);
                normalBuffer.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
                normalBuffer.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
                normalBuffer.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
                vertexBuffer.ensureCapacity(12);
                vertexBuffer.put(localVertices[0][0], localVertices[0][2] + depthA, localVertices[0][1], colorA);
                vertexBuffer.put(localVertices[1][0], localVertices[1][2] + depthB, localVertices[1][1], colorB);
                vertexBuffer.put(localVertices[2][0], localVertices[2][2] + depthC, localVertices[2][1], colorC);
                bufferLength += 3;
                int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, false);
                int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, false);
                int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, false);
                uvBuffer.ensureCapacity(12);
                uvBuffer.put(packedMaterialDataA, (float)localVertices[0][0] / 128.0f, (float)localVertices[0][1] / 128.0f, 0.0f);
                uvBuffer.put(packedMaterialDataB, (float)localVertices[1][0] / 128.0f, (float)localVertices[1][1] / 128.0f, 0.0f);
                uvBuffer.put(packedMaterialDataC, (float)localVertices[2][0] / 128.0f, (float)localVertices[2][1] / 128.0f, 0.0f);
                uvBufferLength += 3;
            }
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int packTerrainData(int waterDepth, WaterType waterType, int plane) {
        int isTerrain = 1;
        return waterDepth << 8 | waterType.ordinal() << 3 | plane << 1 | isTerrain;
    }

    private boolean shouldSkipTile(int worldX, int worldY) {
        return worldX == 2796 && worldY >= 2961 && worldY <= 2967;
    }
}

