/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Stack;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;

public class BufferPool {
    private static final Logger log = LoggerFactory.getLogger(BufferPool.class);
    private final Stack<Long> bufferAddressStack = new Stack();
    private final long byteCapacity;
    private boolean allocated;
    private final HdPlugin hdPlugin;

    public BufferPool(long byteCapacity, HdPlugin hdPlugin) {
        this.byteCapacity = byteCapacity;
        this.allocated = false;
        this.hdPlugin = hdPlugin;
    }

    public boolean isEmpty() {
        return this.bufferAddressStack.isEmpty();
    }

    public void allocate() {
        if (this.allocated) {
            return;
        }
        long allocationSize = 294912L;
        long bytesRemaining = this.byteCapacity;
        try {
            while (bytesRemaining - allocationSize >= 0L) {
                this.bufferAddressStack.push(MemoryUtil.nmemAllocChecked(allocationSize));
                bytesRemaining -= allocationSize;
            }
        }
        catch (OutOfMemoryError oom) {
            log.error("out of memory during initialization -- shutting down");
            this.hdPlugin.stopPlugin();
        }
        this.allocated = true;
    }

    public void free() {
        Iterator iterator2 = this.bufferAddressStack.iterator();
        while (iterator2.hasNext()) {
            Long address = (Long)iterator2.next();
            MemoryUtil.nmemFree(address);
            iterator2.remove();
        }
    }

    public void putIntBuffer(IntBuffer buffer) {
        this.bufferAddressStack.push(MemoryUtil.memAddress(buffer));
    }

    public IntBuffer takeIntBuffer(int capacity) {
        if (this.bufferAddressStack.isEmpty()) {
            return null;
        }
        return MemoryUtil.memIntBuffer(this.bufferAddressStack.pop(), capacity);
    }

    public void putFloatBuffer(FloatBuffer buffer) {
        this.bufferAddressStack.push(MemoryUtil.memAddress(buffer));
    }

    public FloatBuffer takeFloatBuffer(int capacity) {
        if (this.bufferAddressStack.isEmpty()) {
            return null;
        }
        return MemoryUtil.memFloatBuffer(this.bufferAddressStack.pop(), capacity);
    }
}

