/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.plugin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.pushingpixels.substance.api.SubstanceComponentPlugin;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.font.FontSet;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;

public class BasePlugin
implements SubstanceComponentPlugin {
    protected static final String commonDir = "/org/pushingpixels/substance/internal/contrib/randelshofer/quaqua/images/";
    protected static final String quaquaColorChooserClassName = "org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.Quaqua14ColorChooserUI";
    protected boolean hasQuaquaColorChooser;

    public BasePlugin() {
        try {
            Class.forName(quaquaColorChooserClassName);
            this.hasQuaquaColorChooser = true;
        }
        catch (ClassNotFoundException cnfe) {
            this.hasQuaquaColorChooser = false;
        }
    }

    @Override
    public Object[] getDefaults(SubstanceSkin skin) {
        if (this.hasQuaquaColorChooser) {
            int i;
            ResourceBundle bundle = ResourceBundle.getBundle("org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.Labels");
            LinkedList<Object> labelsList = new LinkedList<Object>();
            Enumeration<String> i2 = bundle.getKeys();
            while (i2.hasMoreElements()) {
                String key = i2.nextElement();
                labelsList.add(key);
                labelsList.add(bundle.getObject(key));
            }
            SubstanceColorScheme colorScheme = skin.getEnabledColorScheme(SubstanceSlices.DecorationAreaType.NONE);
            InsetsUIResource visualMargin = new InsetsUIResource(0, 0, 0, 0);
            ColorUIResource foregroundColor = new ColorUIResource(colorScheme.getForegroundColor());
            Object[] mainDefaults = new Object[]{"Slider.upThumbSmall", new UIDefaults.LazyValue(){

                @Override
                public Object createValue(UIDefaults table) {
                    return SubstanceIconFactory.getSliderHorizontalIcon(SubstanceSizeUtils.getSliderIconSize(SubstanceSizeUtils.getControlFontSize()) - 2, true);
                }
            }, "Slider.leftThumbSmall", new UIDefaults.LazyValue(){

                @Override
                public Object createValue(UIDefaults table) {
                    return SubstanceIconFactory.getSliderVerticalIcon(SubstanceSizeUtils.getSliderIconSize(SubstanceSizeUtils.getControlFontSize()) - 2, true);
                }
            }, "Component.visualMargin", visualMargin, "ColorChooser.foreground", foregroundColor, "ColorChooser.defaultChoosers", new String[]{"org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorWheelChooser", "org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSlidersChooser", "org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorPalettesChooser", "org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.SwatchesChooser", "org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.CrayonsChooser", "org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.Quaqua15ColorPicker", "org.pushingpixels.substance.internal.contrib.xoetrope.editor.color.ColorWheelPanel"}, "ColorChooser.swatchesSwatchSize", new DimensionUIResource(5, 5), "ColorChooser.resetMnemonic", new Integer(-1), "ColorChooser.crayonsImage", SubstanceImageCreator.getCrayonsImage(), "ColorChooser.textSliderGap", new Integer(0), "ColorChooser.colorPickerMagnifier", new UIDefaults.LazyValue(){

                @Override
                public Object createValue(UIDefaults table) {
                    BufferedImage result = SubstanceCoreUtilities.getBlankImage(48, 48);
                    Graphics2D g2 = result.createGraphics();
                    g2.setColor(Color.black);
                    g2.translate(-4, -6);
                    int xc = 20;
                    int yc = 22;
                    int r = 15;
                    g2.setStroke(new BasicStroke(2.5f));
                    g2.drawOval(xc - r, yc - r, 2 * r, 2 * r);
                    g2.setStroke(new BasicStroke(4.0f));
                    GeneralPath handle = new GeneralPath();
                    handle.moveTo((float)((double)xc + (double)r / Math.sqrt(2.0)), (float)((double)yc + (double)r / Math.sqrt(2.0)));
                    handle.lineTo(45.0f, 47.0f);
                    g2.draw(handle);
                    g2.translate(4, 6);
                    g2.setStroke(new BasicStroke(1.0f));
                    g2.drawLine(16, 4, 16, 13);
                    g2.drawLine(4, 16, 13, 16);
                    g2.drawLine(16, 19, 16, 28);
                    g2.drawLine(19, 16, 28, 16);
                    return result;
                }
            }, "ColorChooser.colorPickerHotSpot", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{new Integer(29), new Integer(29)}), "ColorChooser.colorPickerPickOffset", new UIDefaults.ProxyLazyValue("java.awt.Point", new Object[]{new Integer(-13), new Integer(-13)}), "ColorChooser.colorPickerGlassRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(3), new Integer(3), new Integer(26), new Integer(26)}), "ColorChooser.colorPickerCaptureRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(-15), new Integer(-15), new Integer(5), new Integer(5)}), "ColorChooser.colorPickerZoomRect", new UIDefaults.ProxyLazyValue("java.awt.Rectangle", new Object[]{new Integer(4), new Integer(4), new Integer(25), new Integer(25)})};
            Object[] colorDefaults = null;
            FontSet substanceFontSet = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet("Substance", null);
            FontUIResource controlFont = substanceFontSet.getControlFont();
            FontUIResource fontBoldBaseP1 = new FontUIResource(controlFont.deriveFont(1, controlFont.getSize() + 1));
            FontUIResource fontPlainBaseM2 = new FontUIResource(controlFont.deriveFont((float)(controlFont.getSize() - 2)));
            colorDefaults = new Object[]{"ColorChooserUI", "org.pushingpixels.substance.internal.ui.SubstanceColorChooserUI", "ColorChooser.font", controlFont, "ColorChooser.smallFont", fontPlainBaseM2, "ColorChooser.crayonsFont", fontBoldBaseP1};
            Object[] labelDefaults = new Object[mainDefaults.length + labelsList.size()];
            for (int i3 = 0; i3 < mainDefaults.length; ++i3) {
                labelDefaults[i3] = mainDefaults[i3];
            }
            int start = mainDefaults.length;
            for (int i4 = 0; i4 < labelsList.size(); ++i4) {
                labelDefaults[start + i4] = labelsList.get(i4);
            }
            mainDefaults = labelDefaults;
            Object[] defaults = new Object[mainDefaults.length + colorDefaults.length];
            for (i = 0; i < mainDefaults.length; ++i) {
                defaults[i] = mainDefaults[i];
            }
            start = mainDefaults.length;
            for (i = 0; i < colorDefaults.length; ++i) {
                defaults[start + i] = colorDefaults[i];
            }
            return defaults;
        }
        return new Object[0];
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void initialize() {
    }
}

