/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class TwilightSkin
extends SubstanceSkin {
    public static final String NAME = "Twilight";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopLineOverlayPainter toolbarTopLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public TwilightSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/twilight.colorschemes");
        SubstanceColorScheme activeScheme = schemes.get("Twilight Active");
        SubstanceColorScheme enabledScheme = schemes.get("Twilight Enabled");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, enabledScheme);
        defaultSchemeBundle.registerColorScheme(enabledScheme, 0.6f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, 0.6f, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderDisabledSelectedScheme = schemes.get("Twilight Selected Disabled Border");
        SubstanceColorScheme borderScheme = schemes.get("Twilight Border");
        defaultSchemeBundle.registerColorScheme(borderDisabledSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme markActiveScheme = schemes.get("Twilight Mark Active");
        defaultSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(markActiveScheme, 0.6f, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme separatorScheme = schemes.get("Twilight Separator");
        defaultSchemeBundle.registerColorScheme(separatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(schemes.get("Twilight Tab Border"), SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.getActiveStates());
        SubstanceColorScheme watermarkScheme = schemes.get("Twilight Watermark");
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, watermarkScheme, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorSchemeBundle decorationsSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, enabledScheme);
        decorationsSchemeBundle.registerColorScheme(enabledScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        decorationsSchemeBundle.registerColorScheme(borderDisabledSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        decorationsSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        decorationsSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        SubstanceColorScheme separatorDecorationsScheme = schemes.get("Twilight Decorations Separator");
        decorationsSchemeBundle.registerColorScheme(separatorDecorationsScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme decorationsWatermarkScheme = schemes.get("Twilight Decorations Watermark");
        this.registerDecorationAreaSchemeBundle(decorationsSchemeBundle, decorationsWatermarkScheme, SubstanceSlices.DecorationAreaType.TOOLBAR, SubstanceSlices.DecorationAreaType.GENERAL, SubstanceSlices.DecorationAreaType.FOOTER);
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, enabledScheme);
        headerSchemeBundle.registerColorScheme(enabledScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme headerBorderScheme = schemes.get("Twilight Header Border");
        headerSchemeBundle.registerColorScheme(borderDisabledSelectedScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(headerBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(markActiveScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.7f, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ROLLOVER_ARMED, ComponentState.ARMED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 0.8f, ComponentState.SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(activeScheme, 1.0f, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme headerWatermarkScheme = schemes.get("Twilight Header Watermark");
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerWatermarkScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        this.setTabFadeStart(0.2);
        this.setTabFadeEnd(0.9);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), SubstanceSlices.DecorationAreaType.FOOTER);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(scheme -> scheme.getUltraDarkColor().darker());
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarTopLineOverlayPainter = new TopLineOverlayPainter(scheme -> SubstanceColorUtilities.getAlphaColor(scheme.getForegroundColor(), 32));
        this.addOverlayPainter(this.toolbarTopLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(scheme -> scheme.getUltraDarkColor().darker(), scheme -> SubstanceColorUtilities.getAlphaColor(scheme.getForegroundColor(), 32));
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, SubstanceSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.LIGHT});
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new ClassicBorderPainter(), new DelegateBorderPainter("Twilight Inner", new ClassicBorderPainter(), 0x40FFFFFF, 0x20FFFFFF, 0xFFFFFF, scheme -> scheme.tint(0.2f)));
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

