/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class MatteDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Matte";

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        if (decorationAreaType == SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
        } else {
            this.paintExtraBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.fill(g2d, comp, scheme, 0, 0, 0, width, height);
        g2d.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
        Point offset = SubstanceCoreUtilities.getOffsetInRootPaneCoords(comp);
        Graphics2D g2d = (Graphics2D)graphics.create();
        this.fill(g2d, comp, scheme, offset.y, 0, 0, width, height);
        g2d.dispose();
    }

    protected void fill(Graphics2D graphics, Component comp, SubstanceColorScheme scheme, int offsetY, int x, int y, int width, int height) {
        int flexPoint = 50;
        int startY = y + offsetY;
        if (startY < 0) {
            startY = 0;
        }
        int endY = startY + height;
        Color startColor = scheme.getLightColor();
        Color endColor = SubstanceColorUtilities.getInterpolatedColor(startColor, scheme.getMidColor(), 0.4f);
        int currStart = 0;
        if (flexPoint >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, startColor, x, flexPoint - offsetY, endColor));
            graphics.fillRect(x, currStart - offsetY, width, flexPoint);
        }
        if ((currStart += flexPoint) > endY) {
            return;
        }
        graphics.setColor(endColor);
        graphics.fillRect(x, currStart - offsetY, width, endY - currStart + offsetY);
    }
}

