/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.pushingpixels.substance.api.SubstanceSlices;

public final class ComponentState {
    private static Set<ComponentState> allStates = new HashSet<ComponentState>();
    public static final ComponentState DISABLED_DEFAULT = new ComponentState("disabled default", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DEFAULT}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE});
    public static final ComponentState DEFAULT = new ComponentState("default", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.DEFAULT, SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    public static final ComponentState DISABLED_SELECTED = new ComponentState("disabled selected", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.SELECTION}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE});
    public static final ComponentState DISABLED_UNSELECTED = new ComponentState("disabled unselected", null, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE, SubstanceSlices.ComponentStateFacet.SELECTION});
    public static final ComponentState PRESSED_SELECTED = new ComponentState("pressed selected", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.SELECTION, SubstanceSlices.ComponentStateFacet.PRESS, SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    public static final ComponentState PRESSED_UNSELECTED = new ComponentState("pressed unselected", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.PRESS, SubstanceSlices.ComponentStateFacet.ENABLE}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.SELECTION});
    public static final ComponentState SELECTED = new ComponentState("selected", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.SELECTION, SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ROLLOVER_SELECTED = new ComponentState("rollover selected", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.SELECTION, SubstanceSlices.ComponentStateFacet.ROLLOVER, SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ARMED = new ComponentState("armed", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ARM, SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ROLLOVER_ARMED = new ComponentState("rollover armed", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ROLLOVER, SubstanceSlices.ComponentStateFacet.ARM, SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ROLLOVER_UNSELECTED = new ComponentState("rollover unselected", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ROLLOVER, SubstanceSlices.ComponentStateFacet.ENABLE}, new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.SELECTION});
    public static final ComponentState ENABLED = new ComponentState("enabled", new SubstanceSlices.ComponentStateFacet[]{SubstanceSlices.ComponentStateFacet.ENABLE}, null);
    private Set<SubstanceSlices.ComponentStateFacet> facetsTurnedOn;
    private Set<SubstanceSlices.ComponentStateFacet> facetsTurnedOff;
    private Map<SubstanceSlices.ComponentStateFacet, Boolean> mapping;
    private String name;
    private ComponentState hardFallback;

    public ComponentState(String name, SubstanceSlices.ComponentStateFacet[] facetsOn, SubstanceSlices.ComponentStateFacet[] facetsOff) {
        this(name, null, facetsOn, facetsOff);
    }

    public ComponentState(String name, ComponentState hardFallback, SubstanceSlices.ComponentStateFacet[] facetsOn, SubstanceSlices.ComponentStateFacet[] facetsOff) {
        if (name == null) {
            throw new IllegalArgumentException("Component state name must be non-null");
        }
        this.name = name;
        this.hardFallback = hardFallback;
        this.facetsTurnedOn = new HashSet<SubstanceSlices.ComponentStateFacet>();
        if (facetsOn != null) {
            for (SubstanceSlices.ComponentStateFacet facetOn : facetsOn) {
                this.facetsTurnedOn.add(facetOn);
            }
        }
        this.facetsTurnedOff = new HashSet<SubstanceSlices.ComponentStateFacet>();
        if (facetsOff != null) {
            for (SubstanceSlices.ComponentStateFacet facetOff : facetsOff) {
                this.facetsTurnedOff.add(facetOff);
            }
        }
        this.mapping = new HashMap<SubstanceSlices.ComponentStateFacet, Boolean>();
        allStates.add(this);
    }

    public String toString() {
        String sep;
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(" : on {");
        if (this.facetsTurnedOn != null) {
            sep = "";
            for (SubstanceSlices.ComponentStateFacet on : this.facetsTurnedOn) {
                sb.append(sep);
                sep = ", ";
                sb.append(on.toString());
            }
        }
        sb.append("} : off {");
        if (this.facetsTurnedOff != null) {
            sep = "";
            for (SubstanceSlices.ComponentStateFacet off : this.facetsTurnedOff) {
                sb.append(sep);
                sep = ", ";
                sb.append(off.toString());
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isFacetActive(SubstanceSlices.ComponentStateFacet stateFacet) {
        Boolean result = this.mapping.get(stateFacet);
        if (result != null) {
            return result;
        }
        if (this.facetsTurnedOn != null && this.facetsTurnedOn.contains(stateFacet)) {
            this.mapping.put(stateFacet, Boolean.TRUE);
            return true;
        }
        this.mapping.put(stateFacet, Boolean.FALSE);
        return false;
    }

    public boolean isDisabled() {
        return !this.isFacetActive(SubstanceSlices.ComponentStateFacet.ENABLE);
    }

    public static ComponentState[] getActiveStates() {
        LinkedList<ComponentState> states = new LinkedList<ComponentState>();
        for (ComponentState state : allStates) {
            if (!state.isActive()) continue;
            states.add(state);
        }
        return states.toArray(new ComponentState[0]);
    }

    public static Set<ComponentState> getAllStates() {
        return Collections.synchronizedSet(allStates);
    }

    public boolean isActive() {
        if (this == ENABLED) {
            return false;
        }
        return this.isFacetActive(SubstanceSlices.ComponentStateFacet.ENABLE);
    }

    public static ComponentState getState(ButtonModel model, JComponent component) {
        return ComponentState.getState(model, component, false);
    }

    public static ComponentState getState(AbstractButton button) {
        return ComponentState.getState(button.getModel(), button, false);
    }

    public static ComponentState getState(ButtonModel model, JComponent component, boolean toIgnoreSelection) {
        JButton jb;
        boolean isRollover = model.isRollover();
        if (component instanceof MenuElement) {
            MenuElement[] selectedMenuPath;
            for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                if (elem != component) continue;
                isRollover = true;
                break;
            }
        }
        if (component != null && component instanceof JButton && (jb = (JButton)component).isDefaultButton()) {
            if (model.isEnabled()) {
                if (jb.isRolloverEnabled() && jb.getModel().isRollover()) {
                    if (model.isSelected()) {
                        return ROLLOVER_SELECTED;
                    }
                    return ROLLOVER_UNSELECTED;
                }
                if (!model.isPressed() && !model.isArmed()) {
                    return DEFAULT;
                }
            } else {
                return DISABLED_DEFAULT;
            }
        }
        boolean isRolloverEnabled = true;
        if (component instanceof AbstractButton) {
            isRolloverEnabled = ((AbstractButton)component).isRolloverEnabled();
        }
        if (!model.isEnabled()) {
            if (!toIgnoreSelection && model.isSelected()) {
                return DISABLED_SELECTED;
            }
            return DISABLED_UNSELECTED;
        }
        if (model.isArmed() && model.isPressed()) {
            if (!toIgnoreSelection && model.isSelected()) {
                return PRESSED_SELECTED;
            }
            return PRESSED_UNSELECTED;
        }
        if (!toIgnoreSelection && model.isSelected()) {
            if ((component == null || isRolloverEnabled) && isRollover) {
                return ROLLOVER_SELECTED;
            }
            return SELECTED;
        }
        if (model.isArmed()) {
            if ((component == null || isRolloverEnabled) && isRollover) {
                return ROLLOVER_ARMED;
            }
            return ARMED;
        }
        if ((component == null || isRolloverEnabled) && isRollover) {
            return ROLLOVER_UNSELECTED;
        }
        return ENABLED;
    }

    public static ComponentState getState(boolean isEnabled, boolean isRollover, boolean isSelected) {
        if (!isEnabled) {
            if (isSelected) {
                return DISABLED_SELECTED;
            }
            return DISABLED_UNSELECTED;
        }
        if (isSelected) {
            if (isRollover) {
                return ROLLOVER_SELECTED;
            }
            return SELECTED;
        }
        if (isRollover) {
            return ROLLOVER_UNSELECTED;
        }
        return ENABLED;
    }

    private int fitValue(ComponentState state) {
        int value = 0;
        if (this.facetsTurnedOn != null) {
            for (SubstanceSlices.ComponentStateFacet on : this.facetsTurnedOn) {
                if (state.facetsTurnedOn == null) {
                    value -= on.value / 2;
                    continue;
                }
                value = state.facetsTurnedOn.contains(on) ? (value += on.value) : (value -= on.value / 2);
                if (!state.facetsTurnedOff.contains(on)) continue;
                value -= on.value;
            }
        }
        if (this.facetsTurnedOff != null) {
            for (SubstanceSlices.ComponentStateFacet off : this.facetsTurnedOff) {
                if (state.facetsTurnedOff == null) {
                    value -= off.value / 2;
                    continue;
                }
                value = state.facetsTurnedOff.contains(off) ? (value += off.value) : (value -= off.value / 2);
                if (!state.facetsTurnedOn.contains(off)) continue;
                value -= off.value;
            }
        }
        return value;
    }

    public ComponentState bestFit(Collection<ComponentState> states) {
        ComponentState bestFit = null;
        int bestFitValue = 0;
        for (ComponentState state : states) {
            if (this.isActive() != state.isActive()) continue;
            int currFitValue = state.fitValue(this) + this.fitValue(state);
            if (bestFit == null) {
                bestFit = state;
                bestFitValue = currFitValue;
                continue;
            }
            if (currFitValue <= bestFitValue) continue;
            bestFit = state;
            bestFitValue = currFitValue;
        }
        if (bestFitValue > 0) {
            return bestFit;
        }
        return null;
    }

    public ComponentState getHardFallback() {
        return this.hardFallback;
    }

    public int hashCode() {
        if (this.facetsTurnedOn.isEmpty() && this.facetsTurnedOff.isEmpty()) {
            return 0;
        }
        if (this.facetsTurnedOn.isEmpty()) {
            boolean isFirst = true;
            int result = 0;
            for (SubstanceSlices.ComponentStateFacet off : this.facetsTurnedOff) {
                if (isFirst) {
                    result = ~off.hashCode();
                    isFirst = false;
                    continue;
                }
                result &= ~off.hashCode();
            }
            return result;
        }
        boolean isFirst = true;
        int result = 0;
        for (SubstanceSlices.ComponentStateFacet on : this.facetsTurnedOn) {
            if (isFirst) {
                result = on.hashCode();
                isFirst = false;
                continue;
            }
            result &= on.hashCode();
        }
        for (SubstanceSlices.ComponentStateFacet off : this.facetsTurnedOff) {
            result &= ~off.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentState)) {
            return false;
        }
        ComponentState second = (ComponentState)obj;
        if (this.facetsTurnedOn.size() != second.facetsTurnedOn.size()) {
            return false;
        }
        if (this.facetsTurnedOff.size() != second.facetsTurnedOff.size()) {
            return false;
        }
        if (!this.facetsTurnedOn.containsAll(second.facetsTurnedOn)) {
            return false;
        }
        return this.facetsTurnedOff.containsAll(second.facetsTurnedOff);
    }
}

