/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.update.verifier;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.codec.digest.DigestUtils;
import org.pf4j.update.FileVerifier;
import org.pf4j.update.VerifyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sha512SumVerifier
implements FileVerifier {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void verify(FileVerifier.Context context, Path file) throws VerifyException, IOException {
        String expectedSha512sum;
        try {
            if (context.sha512sum == null) {
                log.debug("No sha512 checksum specified, skipping verification");
                return;
            }
            if (context.sha512sum.equalsIgnoreCase(".sha512")) {
                String url = context.url.substring(0, context.url.lastIndexOf(".")) + ".sha512";
                expectedSha512sum = this.getUrlContents(url).split(" ")[0].trim();
            } else {
                expectedSha512sum = context.sha512sum.startsWith("http") ? this.getUrlContents(context.sha512sum).split(" ")[0].trim() : context.sha512sum;
            }
        }
        catch (IOException e) {
            throw new VerifyException(e, "SHA512 checksum verification failed, could not download SHA512 file ({})", context.sha512sum);
        }
        log.debug("Verifying sha512 checksum of file {}", (Object)file.getFileName());
        String actualSha512sum = DigestUtils.sha512Hex(Files.newInputStream(file, new OpenOption[0]));
        if (actualSha512sum.equalsIgnoreCase(expectedSha512sum)) {
            log.debug("Checksum OK");
            return;
        }
        throw new VerifyException("SHA512 checksum of downloaded file " + file.getFileName() + " does not match that from plugin descriptor. Got " + actualSha512sum + " but expected " + expectedSha512sum);
    }

    private String getUrlContents(String url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));){
            String string = reader.readLine();
            return string;
        }
    }
}

