/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

class LibTracker {
    private static final Logger logger = Logger.getLogger(LibTracker.class.getName());
    private static final Set<File> libraryFiles = new LinkedHashSet<File>();
    private static Thread shutdownHook = null;

    static synchronized void track(File libraryFile) {
        if (libraryFile == null) {
            return;
        }
        if (shutdownHook == null) {
            logger.fine("Initializing library shutdown hook");
            shutdownHook = new Thread(){

                @Override
                public void run() {
                    LibTracker.shutdown();
                }
            };
            try {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        logger.fine("Tracking library file " + libraryFile);
        libraryFiles.add(libraryFile);
    }

    private static void shutdown() {
        LibTracker.freeNativeLibraries();
        LibTracker.deleteNativeLibraries();
    }

    private static void freeNativeLibraries() {
        ClassLoader classLoader = LibTracker.class.getClassLoader();
        Object nativeLibrariesObject = LibTracker.getFieldValueOptional(classLoader, "nativeLibraries");
        if (nativeLibrariesObject == null) {
            return;
        }
        if (!(nativeLibrariesObject instanceof List)) {
            return;
        }
        List nativeLibraries = (List)nativeLibrariesObject;
        for (Object nativeLibrary : nativeLibraries) {
            LibTracker.freeNativeLibrary(nativeLibrary);
        }
    }

    private static void freeNativeLibrary(Object library) {
        Object nameObject = LibTracker.getFieldValueOptional(library, "name");
        if (nameObject == null) {
            return;
        }
        String name = String.valueOf(nameObject);
        File file = new File(name);
        if (libraryFiles.contains(file)) {
            LibTracker.invokeFinalizeOptional(library);
        }
    }

    private static void deleteNativeLibraries() {
        for (File libraryFile : libraryFiles) {
            if (!libraryFile.exists()) continue;
            try {
                boolean deleted = libraryFile.delete();
                logger.fine("Deleting " + libraryFile + " " + (deleted ? "DONE" : "FAILED"));
            }
            catch (SecurityException securityException) {}
        }
        libraryFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFieldValueOptional(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        Class<?> c = object.getClass();
        Field field = LibTracker.getDeclaredField(c, fieldName);
        if (field == null) {
            return null;
        }
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                Object object2 = field.get(object);
                return object2;
            }
            catch (Exception e) {
                Object var6_8 = null;
                try {
                    field.setAccessible(wasAccessible);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return var6_8;
            }
        }
        finally {
            try {
                field.setAccessible(wasAccessible);
            }
            catch (SecurityException securityException) {}
        }
    }

    private static Field getDeclaredField(Class<?> c, String fieldName) {
        if (c == null) {
            return null;
        }
        try {
            Field field = c.getDeclaredField(fieldName);
            return field;
        }
        catch (Exception e) {
            return LibTracker.getDeclaredField(c.getSuperclass(), fieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeFinalizeOptional(Object object) {
        if (object == null) {
            return;
        }
        Method method = null;
        boolean wasAccessible = false;
        try {
            Class<?> c = object.getClass();
            method = c.getDeclaredMethod("finalize", new Class[0]);
            wasAccessible = method.isAccessible();
            method.setAccessible(true);
            method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
        }
        finally {
            if (method != null) {
                try {
                    method.setAccessible(wasAccessible);
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    private LibTracker() {
    }
}

