/*
 * Decompiled with CFR 0.152.
 */
package net.unethicalite.client.managers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class InventoryManager {
    private static final Map<Integer, Item[]> cachedContainers = new ConcurrentHashMap<Integer, Item[]>();
    @Inject
    private Client client;

    @Inject
    InventoryManager(EventBus eventBus) {
        eventBus.register(this);
    }

    @Subscribe(priority=2.1474836E9f)
    private void onItemContainerChanged(ItemContainerChanged e) {
        cachedContainers.put(e.getContainerId(), e.getItemContainer().getItems());
        if (e.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.client.runScript(6009, 0x950000, 28, 1, -1);
        }
    }

    public static Map<Integer, Item[]> getCachedContainers() {
        return cachedContainers;
    }
}

