/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import javax.swing.JFrame;
import net.runelite.client.util.OSType;
import org.madlonkay.desktopsupport.DesktopSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSXUtil {
    private static final Logger log = LoggerFactory.getLogger(OSXUtil.class);

    public static void tryEnableFullscreen(JFrame gui) {
        if (OSType.getOSType() == OSType.MacOS) {
            DesktopSupport.getSupport().setWindowCanFullScreen(gui, true);
            log.debug("Enabled fullscreen on macOS");
        }
    }

    public static void requestUserAttention() {
        DesktopSupport.getSupport().requestUserAttention(true);
        log.debug("Requested user attention on macOS");
    }

    public static void requestForeground() {
        DesktopSupport.getSupport().requestForeground(true);
        log.debug("Forced focus on macOS");
    }
}

