/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.feed;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.feed.FeedConfig;
import net.runelite.client.plugins.feed.FeedPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="News Feed", description="Show the latest RuneLite blog posts, OSRS news, and JMod Twitter posts", tags={"external", "integration", "panel", "twitter"}, loadWhenOutdated=true)
public class FeedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FeedPlugin.class);
    @Inject
    private ClientToolbar clientToolbar;
    private FeedPanel feedPanel;
    private NavigationButton navButton;

    @Override
    protected void startUp() throws Exception {
        this.feedPanel = this.injector.getInstance(FeedPanel.class);
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), "icon.png");
        this.navButton = NavigationButton.builder().tooltip("News Feed").icon(icon).priority(8).panel(this.feedPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.feedPanel.stop();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("feed")) {
            this.feedPanel.rebuild();
        }
    }

    @Provides
    FeedConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(FeedConfig.class);
    }
}

