/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.examine;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.examine.ExamineType;
import net.runelite.client.plugins.examine.PendingExamine;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Examine", description="Shows additional examine information (eg. GE Average, HA Value)", tags={"npcs", "items", "inventory", "objects", "prices", "high alchemy"})
public class ExaminePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ExaminePlugin.class);
    private final Deque<PendingExamine> pending = new ArrayDeque<PendingExamine>();
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.pending.clear();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        int id;
        ExamineType type;
        if (!Text.removeTags(event.getMenuOption()).equals("Examine")) {
            return;
        }
        int quantity = -1;
        switch (event.getMenuAction()) {
            case EXAMINE_ITEM: {
                type = ExamineType.ITEM;
                id = event.getId();
                int widgetId = event.getParam1();
                int widgetGroup = WidgetInfo.TO_GROUP(widgetId);
                int widgetChild = WidgetInfo.TO_CHILD(widgetId);
                Widget widget = this.client.getWidget(widgetGroup, widgetChild);
                WidgetItem widgetItem = widget.getWidgetItem(event.getParam0());
                int n = quantity = widgetItem != null && widgetItem.getId() >= 0 ? widgetItem.getQuantity() : 1;
                if (quantity < 100000) break;
                int itemId = event.getId();
                ChatMessageBuilder message = new ChatMessageBuilder().append(QuantityFormatter.formatNumber(quantity)).append(" x ").append(this.itemManager.getItemComposition(itemId).getMembersName());
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(message.build()).build());
                event.consume();
                break;
            }
            case EXAMINE_ITEM_GROUND: {
                type = ExamineType.ITEM;
                id = event.getId();
                break;
            }
            case CC_OP_LOW_PRIORITY: {
                type = ExamineType.IF3_ITEM;
                int[] qi = this.findItemFromWidget(event.getParam1(), event.getParam0());
                if (qi == null) {
                    log.debug("Examine for item with unknown widget: {}", (Object)event);
                    return;
                }
                quantity = qi[0];
                id = qi[1];
                break;
            }
            case EXAMINE_OBJECT: {
                type = ExamineType.OBJECT;
                id = event.getId();
                break;
            }
            case EXAMINE_NPC: {
                type = ExamineType.NPC;
                id = event.getId();
                break;
            }
            default: {
                return;
            }
        }
        PendingExamine pendingExamine = new PendingExamine();
        pendingExamine.setType(type);
        pendingExamine.setId(id);
        pendingExamine.setQuantity(quantity);
        pendingExamine.setCreated(Instant.now());
        this.pending.push(pendingExamine);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        ExamineType type;
        switch (event.getType()) {
            case OBJECT_EXAMINE: {
                type = ExamineType.OBJECT;
                break;
            }
            case NPC_EXAMINE: {
                type = ExamineType.NPC;
                break;
            }
            case GAMEMESSAGE: 
            case ITEM_EXAMINE: {
                type = ExamineType.IF3_ITEM;
                break;
            }
            default: {
                return;
            }
        }
        if (this.pending.isEmpty()) {
            log.debug("Got examine without a pending examine?");
            return;
        }
        PendingExamine pendingExamine = this.pending.pop();
        if (pendingExamine.getType() != type) {
            log.debug("Type mismatch for pending examine: {} != {}", (Object)pendingExamine.getType(), (Object)type);
            this.pending.clear();
            return;
        }
        log.debug("Got examine for {} {}: {}", new Object[]{pendingExamine.getType(), pendingExamine.getId(), event.getMessage()});
        if (pendingExamine.getType() == ExamineType.ITEM || pendingExamine.getType() == ExamineType.IF3_ITEM) {
            int itemId = pendingExamine.getId();
            int itemQuantity = pendingExamine.getQuantity();
            if (itemId == 995) {
                return;
            }
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            this.getItemPrice(itemComposition.getId(), itemComposition, itemQuantity);
        }
    }

    private int[] findItemFromWidget(int widgetId, int childIdx) {
        int widgetGroup = WidgetInfo.TO_GROUP(widgetId);
        Widget widget = this.client.getWidget(widgetId);
        if (widget == null) {
            return null;
        }
        if (WidgetInfo.EQUIPMENT.getGroupId() == widgetGroup) {
            Widget widgetItem = widget.getChild(1);
            if (widgetItem != null) {
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (WidgetInfo.SMITHING_INVENTORY_ITEMS_CONTAINER.getGroupId() == widgetGroup) {
            Widget widgetItem = widget.getChild(2);
            if (widgetItem != null) {
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        } else if (300 == widgetGroup) {
            Widget widgetItem = widget.getChild(childIdx);
            if (widgetItem != null) {
                return new int[]{1, widgetItem.getItemId()};
            }
        } else {
            Widget widgetItem = widget.getChild(childIdx);
            if (widgetItem != null && widgetItem.getItemId() > -1) {
                return new int[]{widgetItem.getItemQuantity(), widgetItem.getItemId()};
            }
        }
        return null;
    }

    @VisibleForTesting
    void getItemPrice(int id, ItemComposition itemComposition, int quantity) {
        quantity = Math.max(1, quantity);
        int gePrice = this.itemManager.getItemPrice(id);
        int alchPrice = itemComposition.getHaPrice();
        if (gePrice > 0 || alchPrice > 0) {
            ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Price of ").append(ChatColorType.HIGHLIGHT);
            if (quantity > 1) {
                message.append(QuantityFormatter.formatNumber(quantity)).append(" x ");
            }
            message.append(itemComposition.getMembersName()).append(ChatColorType.NORMAL).append(":");
            if (gePrice > 0) {
                message.append(ChatColorType.NORMAL).append(" GE average ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)gePrice * (long)quantity));
                if (quantity > 1) {
                    message.append(ChatColorType.NORMAL).append(" (").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber(gePrice)).append(ChatColorType.NORMAL).append("ea)");
                }
            }
            if (alchPrice > 0) {
                message.append(ChatColorType.NORMAL).append(" HA value ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)alchPrice * (long)quantity));
                if (quantity > 1) {
                    message.append(ChatColorType.NORMAL).append(" (").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber(alchPrice)).append(ChatColorType.NORMAL).append("ea)");
                }
            }
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(message.build()).build());
        }
    }
}

