/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.curseprayertooltip;

public enum CursePrayer {
    PROTECT_ITEM(0, 0, 50, "Protect Item", "Keep one extra item if you die."),
    SAP_WARRIOR(1, 0, 50, "Sap Warrior", "Decrease target's Attack by 5%."),
    SAP_RANGER(2, 0, 52, "Sap Ranger", "Decrease target's Ranged by 5%."),
    SAP_MAGE(3, 0, 54, "Sap Mage", "Decrease target's Magic by 5%."),
    SAP_SPIRIT(4, 0, 56, "Sap Spirit", "Decrease target's Summoning by 5%."),
    BERSERKER(0, 1, 59, "Berserker", "Increase your Attack by 10%."),
    DEFLECT_SUMMONING(1, 1, 62, "Deflect Summoning", "Protects from summoning attacks and deflects some damage."),
    DEFLECT_MAGIC(2, 1, 65, "Deflect Magic", "Protects from magic attacks and deflects some damage."),
    DEFLECT_MISSILES(3, 1, 68, "Deflect Missiles", "Protects from ranged attacks and deflects some damage."),
    DEFLECT_MELEE(4, 1, 71, "Deflect Melee", "Protects from melee attacks and deflects some damage."),
    LEECH_ATTACK(0, 2, 74, "Leech Attack", "Boost Attack by 5% while reducing target's by 10%."),
    LEECH_RANGED(1, 2, 76, "Leech Ranged", "Boost Ranged by 5% while reducing target's by 10%."),
    LEECH_MAGIC(2, 2, 78, "Leech Magic", "Boost Magic by 5% while reducing target's by 10%."),
    LEECH_DEFENCE(3, 2, 80, "Leech Defence", "Boost Defence by 5% while reducing target's by 10%."),
    LEECH_STRENGTH(4, 2, 82, "Leech Strength", "Boost Strength by 5% while reducing target's by 10%."),
    LEECH_ENERGY(0, 3, 84, "Leech Energy", "Restore run energy while draining target's."),
    LEECH_SPECIAL_ATTACK(1, 3, 86, "Leech Special Attack", "Restore special attack while draining target's."),
    WRATH(2, 3, 89, "Wrath", "Damages nearby enemies when you die."),
    SOUL_SPLIT(3, 3, 92, "Soul Split", "Heals you for damage dealt and damages target's Prayer."),
    TURMOIL(4, 3, 95, "Turmoil", "Increase Attack, Strength, and Defence by 15%."),
    ANGUISH(0, 4, 95, "Anguish", "Increase Ranged and Defence by 15%."),
    TORMENT(1, 4, 95, "Torment", "Increase Magic and Defence by 15%.");

    private final int gridX;
    private final int gridY;
    private final int levelRequired;
    private final String prayerName;
    private final String description;

    private CursePrayer(int gridX, int gridY, int levelRequired, String prayerName, String description) {
        this.gridX = gridX;
        this.gridY = gridY;
        this.levelRequired = levelRequired;
        this.prayerName = prayerName;
        this.description = description;
    }

    public String getTooltipText() {
        return String.format("Level %d: %s</br>%s", this.levelRequired, this.prayerName, this.description);
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public int getLevelRequired() {
        return this.levelRequired;
    }

    public String getPrayerName() {
        return this.prayerName;
    }

    public String getDescription() {
        return this.description;
    }
}

