/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins;

import com.openosrs.client.OpenOSRS;
import com.openosrs.client.config.OpenOSRSConfig;
import com.openosrs.client.util.Groups;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.client.config.ConfigManager;
import org.pf4j.PluginManager;
import org.pf4j.update.UpdateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OPRSExternalPluginManager {
    private static final Logger log = LoggerFactory.getLogger(OPRSExternalPluginManager.class);
    public static final String DEFAULT_PLUGIN_REPOS = "";
    static final String DEVELOPMENT_MANIFEST_PATH = "build/tmp/jar/MANIFEST.MF";
    public static ArrayList<ClassLoader> pluginClassLoaders = new ArrayList();
    private PluginManager externalPluginManager;
    private final List<UpdateRepository> repositories = new ArrayList<UpdateRepository>();
    @Inject
    private OpenOSRSConfig openOSRSConfig;
    @Inject
    private ConfigManager configManager;
    private final Map<String, String> pluginsMap = new HashMap<String, String>();
    private static final boolean developmentMode = OpenOSRS.getPluginDevelopmentPath().length > 0;
    private final Map<String, Map<String, String>> pluginsInfoMap = new HashMap<String, Map<String, String>>();
    @Inject
    private Groups groups;
    @Inject
    @Named(value="safeMode")
    private boolean safeMode;
    boolean isOutdated;

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    public void setWarning(boolean val) {
        this.configManager.setConfiguration("openosrs", "warning", val);
    }

    public boolean getWarning() {
        return this.openOSRSConfig.warning();
    }

    public void update() {
        if (this.groups != null && this.groups.getInstanceCount() > 1) {
            log.info("Not updating external plugins since there is more than 1 client open");
            return;
        }
        if (developmentMode) {
            log.debug("Not updating because we're running in developer mode");
            return;
        }
    }

    public PluginManager getExternalPluginManager() {
        return this.externalPluginManager;
    }

    public List<UpdateRepository> getRepositories() {
        return this.repositories;
    }

    public static boolean isDevelopmentMode() {
        return developmentMode;
    }

    public Map<String, Map<String, String>> getPluginsInfoMap() {
        return this.pluginsInfoMap;
    }

    public void setOutdated(boolean isOutdated) {
        this.isOutdated = isOutdated;
    }
}

