/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ObservableQueueDrain;
import io.reactivex.rxjava3.internal.util.QueueDrain;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class QueueDrainHelper {
    static final long COMPLETED_MASK = Long.MIN_VALUE;
    static final long REQUESTED_MASK = Long.MAX_VALUE;

    private QueueDrainHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, U> void drainMaxLoop(SimplePlainQueue<T> q, Subscriber<? super U> a, boolean delayError, Disposable dispose, QueueDrain<T, U> qd) {
        int missed = 1;
        while (true) {
            boolean empty;
            boolean d = qd.done();
            T v = q.poll();
            boolean bl = empty = v == null;
            if (QueueDrainHelper.checkTerminated(d, empty, a, delayError, q, qd)) {
                if (dispose != null) {
                    dispose.dispose();
                }
                return;
            }
            if (!empty) {
                long r = qd.requested();
                if (r != 0L) {
                    if (!qd.accept(a, v) || r == Long.MAX_VALUE) continue;
                    qd.produced(1L);
                    continue;
                }
                q.clear();
                if (dispose != null) {
                    dispose.dispose();
                }
                a.onError(new MissingBackpressureException("Could not emit value due to lack of requests."));
                return;
            }
            if ((missed = qd.leave(-missed)) == 0) break;
        }
    }

    public static <T, U> boolean checkTerminated(boolean d, boolean empty, Subscriber<?> s2, boolean delayError, SimpleQueue<?> q, QueueDrain<T, U> qd) {
        if (qd.cancelled()) {
            q.clear();
            return true;
        }
        if (d) {
            if (delayError) {
                if (empty) {
                    Throwable err = qd.error();
                    if (err != null) {
                        s2.onError(err);
                    } else {
                        s2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable err = qd.error();
                if (err != null) {
                    q.clear();
                    s2.onError(err);
                    return true;
                }
                if (empty) {
                    s2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    public static <T, U> void drainLoop(SimplePlainQueue<T> q, Observer<? super U> a, boolean delayError, Disposable dispose, ObservableQueueDrain<T, U> qd) {
        int missed = 1;
        block0: do {
            if (QueueDrainHelper.checkTerminated(qd.done(), q.isEmpty(), a, delayError, q, dispose, qd)) {
                return;
            }
            while (true) {
                boolean empty;
                boolean d = qd.done();
                T v = q.poll();
                boolean bl = empty = v == null;
                if (QueueDrainHelper.checkTerminated(d, empty, a, delayError, q, dispose, qd)) {
                    return;
                }
                if (empty) continue block0;
                qd.accept(a, v);
            }
        } while ((missed = qd.leave(-missed)) != 0);
    }

    public static <T, U> boolean checkTerminated(boolean d, boolean empty, Observer<?> observer, boolean delayError, SimpleQueue<?> q, Disposable disposable, ObservableQueueDrain<T, U> qd) {
        if (qd.cancelled()) {
            q.clear();
            disposable.dispose();
            return true;
        }
        if (d) {
            if (delayError) {
                if (empty) {
                    Throwable err;
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    if ((err = qd.error()) != null) {
                        observer.onError(err);
                    } else {
                        observer.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable err = qd.error();
                if (err != null) {
                    q.clear();
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    observer.onError(err);
                    return true;
                }
                if (empty) {
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    observer.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> SimpleQueue<T> createQueue(int capacityHint) {
        if (capacityHint < 0) {
            return new SpscLinkedArrayQueue(-capacityHint);
        }
        return new SpscArrayQueue(capacityHint);
    }

    public static void request(Subscription s2, int prefetch) {
        s2.request(prefetch < 0 ? Long.MAX_VALUE : (long)prefetch);
    }

    public static <T> boolean postCompleteRequest(long n, Subscriber<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long r0;
        long u;
        long r;
        while (!state.compareAndSet(r = state.get(), u = r & Long.MIN_VALUE | BackpressureHelper.addCap(r0 = r & Long.MAX_VALUE, n))) {
        }
        if (r == Long.MIN_VALUE) {
            QueueDrainHelper.postCompleteDrain(n | Long.MIN_VALUE, actual, queue, state, isCancelled);
            return true;
        }
        return false;
    }

    static boolean isCancelled(BooleanSupplier cancelled) {
        try {
            return cancelled.getAsBoolean();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            return true;
        }
    }

    static <T> boolean postCompleteDrain(long n, Subscriber<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long e = n & Long.MIN_VALUE;
        while (true) {
            if (e != n) {
                if (QueueDrainHelper.isCancelled(isCancelled)) {
                    return true;
                }
                T t = queue.poll();
                if (t == null) {
                    actual.onComplete();
                    return true;
                }
                actual.onNext(t);
                ++e;
                continue;
            }
            if (QueueDrainHelper.isCancelled(isCancelled)) {
                return true;
            }
            if (queue.isEmpty()) {
                actual.onComplete();
                return true;
            }
            n = state.get();
            if (n != e) continue;
            n = state.addAndGet(-(e & Long.MAX_VALUE));
            if ((n & Long.MAX_VALUE) == 0L) {
                return false;
            }
            e = n & Long.MIN_VALUE;
        }
    }

    public static <T> void postComplete(Subscriber<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long u;
        long r;
        if (queue.isEmpty()) {
            actual.onComplete();
            return;
        }
        if (QueueDrainHelper.postCompleteDrain(state.get(), actual, queue, state, isCancelled)) {
            return;
        }
        do {
            if (((r = state.get()) & Long.MIN_VALUE) == 0L) continue;
            return;
        } while (!state.compareAndSet(r, u = r | Long.MIN_VALUE));
        if (r != 0L) {
            QueueDrainHelper.postCompleteDrain(u, actual, queue, state, isCancelled);
        }
    }
}

