/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper;

import com.zulrahhelper.Phase;
import com.zulrahhelper.options.Attack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class State {
    private Phase selectedPhase = START_PHASE;
    public static final Phase START_PHASE = Phase.builder(Phase.Rotation.START, 1).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).build();
    List<List<Phase>> START = Arrays.asList(Collections.singletonList(START_PHASE), Arrays.asList(Phase.builder(Phase.Rotation.MAGMA, 2).addAttack(Attack.NORMAL_2).build(), Phase.builder(Phase.Rotation.NORMAL, 2).addAttack(Attack.NORMAL_5).addAttack(Attack.SNAKELING_3).setRangedPray().build(), Phase.builder(Phase.Rotation.TANZ, 2).addAttack(Attack.NORMAL_6).setMagePray().build()));
    List<List<Phase>> MAGMA = Arrays.asList(Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA, 1).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA, 2).addAttack(Attack.NORMAL_2).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA, 3).addAttack(Attack.NORMAL_4).setMagePray().build()), Arrays.asList(Phase.builder(Phase.Rotation.MAGMA_A, 4).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_2).addAttack(Attack.SNAKELING_4).setRangedPray().build(), Phase.builder(Phase.Rotation.MAGMA_B, 4).addAttack(Attack.VENOM_4).addAttack(Attack.SNAKELING_4).build()));
    List<List<Phase>> MAGMA_A = Arrays.asList(Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 1).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 2).addAttack(Attack.NORMAL_2).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 3).addAttack(Attack.NORMAL_4).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 4).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_2).addAttack(Attack.SNAKELING_4).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 5).addAttack(Attack.NORMAL_2).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 6).addAttack(Attack.NORMAL_2).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 7).addAttack(Attack.VENOM_3).addAttack(Attack.SNAKELING_4).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 8).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_2).addAttack(Attack.SNAKELING_3).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 9).addAttack(Attack.NORMAL_10).addAttack(Attack.VENOM_4).setRangedPray().setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_A, 10).build()));
    List<List<Phase>> MAGMA_B = Arrays.asList(Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 1).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 2).addAttack(Attack.NORMAL_2).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 3).addAttack(Attack.NORMAL_4).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 4).addAttack(Attack.VENOM_3).addAttack(Attack.SNAKELING_4).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 5).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_2).addAttack(Attack.SNAKELING_4).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 6).addAttack(Attack.NORMAL_2).build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 7).addAttack(Attack.NORMAL_5).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 8).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_2).addAttack(Attack.SNAKELING_3).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 9).addAttack(Attack.NORMAL_10).addAttack(Attack.VENOM_4).setRangedPray().setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.MAGMA_B, 10).addAttack(Attack.NORMAL_2).build()));
    List<List<Phase>> NORMAL = Arrays.asList(Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 1).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 2).addAttack(Attack.NORMAL_5).addAttack(Attack.SNAKELING_3).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 3).addAttack(Attack.NORMAL_2).addAttack(Attack.VENOM_3).addAttack(Attack.SNAKELING_3).build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 4).addAttack(Attack.NORMAL_5).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 5).addAttack(Attack.NORMAL_5).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 6).addAttack(Attack.NORMAL_5).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 7).addAttack(Attack.VENOM_3).addAttack(Attack.SNAKELING_3).build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 8).addAttack(Attack.NORMAL_5).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 9).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_2).addAttack(Attack.SNAKELING_3).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 10).addAttack(Attack.NORMAL_10).setMagePray().setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.NORMAL, 11).addAttack(Attack.SNAKELING_4).build()));
    List<List<Phase>> TANZ = Arrays.asList(Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 1).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 2).addAttack(Attack.NORMAL_6).addAttack(Attack.SNAKELING_4).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 3).addAttack(Attack.NORMAL_4).addAttack(Attack.VENOM_2).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 4).addAttack(Attack.NORMAL_4).addAttack(Attack.SNAKELING_4).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 5).addAttack(Attack.NORMAL_2).addAttack(Attack.VENOM_2).build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 6).addAttack(Attack.NORMAL_4).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 7).addAttack(Attack.VENOM_3).addAttack(Attack.SNAKELING_6).build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 8).addAttack(Attack.NORMAL_5).addAttack(Attack.VENOM_4).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 9).addAttack(Attack.NORMAL_5).setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 10).addAttack(Attack.NORMAL_4).addAttack(Attack.VENOM_3).setMagePray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 11).addAttack(Attack.NORMAL_8).setMagePray().setRangedPray().build()), Collections.singletonList(Phase.builder(Phase.Rotation.TANZ, 12).addAttack(Attack.SNAKELING_4).build()));

    public int getNumber() {
        return this.selectedPhase.getNumber();
    }

    public Phase.Rotation getRotation() {
        return this.selectedPhase.getRotation();
    }

    public void setPhase(Phase phase) {
        this.selectedPhase = phase.copy();
        if (phase.getRotation() == Phase.Rotation.MAGMA && phase.getNumber() == 2) {
            this.selectedPhase = this.MAGMA.get(2).get(0);
        }
    }

    public Phase getPhase() {
        return this.selectedPhase;
    }

    public void reset() {
        this.selectedPhase = START_PHASE;
    }

    public String toString() {
        return "State{, selectedPhase=" + this.selectedPhase.toString() + "}";
    }

    public List<List<Phase>> buildTree() {
        List<List<Phase>> tree = this.getRotationTree();
        for (List<Phase> phases : tree) {
            if (phases.size() <= 0) break;
            for (Phase p : phases) {
                p.setStates(this);
            }
            if (phases.get(0).getNumber() <= this.getNumber() + 1 || phases.size() <= 1) continue;
            tree = tree.subList(0, tree.indexOf(phases) + 1);
            break;
        }
        return tree;
    }

    public List<List<Phase>> getRotationTree() {
        List<List<Phase>> tree = new ArrayList<List<Phase>>();
        switch (this.selectedPhase.getRotation()) {
            case START: {
                tree = this.START;
                break;
            }
            case NORMAL: {
                tree = this.NORMAL;
                break;
            }
            case MAGMA: {
                tree = this.MAGMA;
                break;
            }
            case MAGMA_A: {
                tree = this.MAGMA_A;
                break;
            }
            case MAGMA_B: {
                tree = this.MAGMA_B;
                break;
            }
            case TANZ: {
                tree = this.TANZ;
            }
        }
        return tree;
    }
}

