/*
 * Decompiled with CFR 0.152.
 */
package com.radiusmarkers;

import com.radiusmarkers.ColourRadiusMarker;
import com.radiusmarkers.PanelFilter;
import com.radiusmarkers.RadiusMarkerConfig;
import com.radiusmarkers.RadiusMarkerPanel;
import com.radiusmarkers.RadiusMarkerPlugin;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

class RadiusMarkerPluginPanel
extends PluginPanel {
    private static final ImageIcon COPY_ICON;
    private static final ImageIcon COPY_HOVER_ICON;
    private static final ImageIcon PASTE_ICON;
    private static final ImageIcon PASTE_HOVER_ICON;
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon[] FILTER_ICONS;
    private static final String[] FILTER_TEXT;
    private static final String[] FILTER_DESCRIPTIONS;
    private final JLabel copyMarkers = new JLabel(COPY_ICON);
    private final JLabel pasteMarkers = new JLabel(PASTE_ICON);
    private final JLabel markerAdd = new JLabel(ADD_ICON);
    private final JLabel title = new JLabel();
    private final JLabel filter = new JLabel(FILTER_ICONS[0]);
    private final IconTextField searchBar = new IconTextField();
    private final PluginErrorPanel noMarkersPanel = new PluginErrorPanel();
    private final JPanel markerView = new JPanel();
    private final JPanel searchPanel = new JPanel(new BorderLayout());
    private final Client client;
    private final RadiusMarkerPlugin plugin;
    private final RadiusMarkerConfig config;
    private PanelFilter panelFilter = PanelFilter.ALL;

    public RadiusMarkerPluginPanel(Client client, RadiusMarkerPlugin plugin, RadiusMarkerConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(1, 3, 10, 7));
        JPanel markerButtons = new JPanel(new FlowLayout(2, 7, 3));
        this.searchPanel.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        this.searchBar.setPreferredSize(new Dimension(182 - this.filter.getWidth(), 24));
        this.searchBar.addActionListener(e -> this.rebuild());
        this.searchBar.addClearListener(this::rebuild);
        this.searchBar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    RadiusMarkerPluginPanel.this.searchBar.setText("");
                    RadiusMarkerPluginPanel.this.rebuild();
                }
            }
        });
        this.filter.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.filter.setOpaque(true);
        this.filter.setPreferredSize(new Dimension(28, 24));
        this.filter.setText(FILTER_TEXT[0]);
        this.filter.setToolTipText(FILTER_DESCRIPTIONS[0]);
        this.filter.setHorizontalTextPosition(0);
        this.filter.setFont(FontManager.getRunescapeSmallFont());
        this.filter.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPluginPanel.this.panelFilter = RadiusMarkerPluginPanel.this.panelFilter.next();
                RadiusMarkerPluginPanel.this.filter.setText(FILTER_TEXT[RadiusMarkerPluginPanel.this.panelFilter.ordinal()]);
                RadiusMarkerPluginPanel.this.filter.setIcon(FILTER_ICONS[RadiusMarkerPluginPanel.this.panelFilter.ordinal()]);
                RadiusMarkerPluginPanel.this.filter.setToolTipText(FILTER_DESCRIPTIONS[RadiusMarkerPluginPanel.this.panelFilter.ordinal()]);
                RadiusMarkerPluginPanel.this.rebuild();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPluginPanel.this.filter.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPluginPanel.this.filter.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        this.title.setText("Radius Markers");
        this.title.setForeground(Color.WHITE);
        titlePanel.add((Component)this.title, "West");
        titlePanel.add((Component)markerButtons, "East");
        this.searchPanel.add((Component)this.searchBar, "West");
        this.searchPanel.add((Component)this.filter, "East");
        northPanel.add((Component)titlePanel, "North");
        northPanel.add((Component)this.searchPanel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.markerView.setLayout(new BoxLayout(this.markerView, 1));
        this.markerView.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.noMarkersPanel.setVisible(false);
        this.markerView.add(this.noMarkersPanel);
        this.copyMarkers.setToolTipText("Export all searched or filtered markers to your clipboard");
        this.copyMarkers.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RadiusMarkerPluginPanel.this.copyMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RadiusMarkerPluginPanel.this.copyMarkers.setIcon(COPY_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RadiusMarkerPluginPanel.this.copyMarkers.setIcon(COPY_ICON);
            }
        });
        this.pasteMarkers.setToolTipText("Import markers from your clipboard");
        this.pasteMarkers.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RadiusMarkerPluginPanel.this.pasteMarkers();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RadiusMarkerPluginPanel.this.pasteMarkers.setIcon(PASTE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RadiusMarkerPluginPanel.this.pasteMarkers.setIcon(PASTE_ICON);
            }
        });
        this.markerAdd.setToolTipText("Add new radius marker");
        this.markerAdd.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RadiusMarkerPluginPanel.this.addMarker();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RadiusMarkerPluginPanel.this.markerAdd.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RadiusMarkerPluginPanel.this.markerAdd.setIcon(ADD_ICON);
            }
        });
        markerButtons.add(this.pasteMarkers);
        markerButtons.add(this.copyMarkers);
        markerButtons.add(this.markerAdd);
        centerPanel.add((Component)this.markerView, "North");
        this.add((Component)northPanel, "North");
        this.add((Component)centerPanel, "Center");
    }

    public void rebuild() {
        this.markerView.removeAll();
        int regionId = this.client.getLocalPlayer() == null ? -1 : this.client.getLocalPlayer().getWorldLocation().getRegionID();
        for (ColourRadiusMarker marker : this.plugin.getMarkers()) {
            if (!marker.getName().toLowerCase().contains(this.getSearchText().toLowerCase()) || !(PanelFilter.ALL.equals((Object)this.panelFilter) || PanelFilter.REGION.equals((Object)this.panelFilter) && marker.getWorldPoint().getRegionID() == regionId || PanelFilter.VISIBLE.equals((Object)this.panelFilter) && marker.isVisible()) && (!PanelFilter.INVISIBLE.equals((Object)this.panelFilter) || marker.isVisible())) continue;
            this.markerView.add(new RadiusMarkerPanel(this.plugin, this.config, marker));
            this.markerView.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        boolean empty = this.markerView.getComponentCount() == 0;
        this.noMarkersPanel.setContent("Radius Markers", "Click the '+' button to add a radius marker at the feet of your character.");
        this.noMarkersPanel.setVisible(empty);
        this.searchPanel.setVisible(!empty);
        if (empty && this.plugin.getMarkers().size() > 0) {
            this.noMarkersPanel.setContent("Radius Markers", "No radius markers are available for the current search term and/or selected filter.");
            this.searchPanel.setVisible(true);
        }
        this.markerView.add(this.noMarkersPanel);
        this.repaint();
        this.revalidate();
    }

    public String getSearchText() {
        return this.searchBar.getText();
    }

    private void addMarker() {
        this.noMarkersPanel.setVisible(false);
        this.searchPanel.setVisible(true);
        ColourRadiusMarker marker = this.plugin.addMarker();
        SwingUtilities.invokeLater(() -> {
            if (marker != null && marker.getPanel() != null) {
                Rectangle markerPosition = marker.getPanel().getBounds();
                markerPosition.setLocation((int)markerPosition.getX(), (int)markerPosition.getY() - 10 - (int)markerPosition.getHeight() / 2 + ((Applet)((Object)this.client)).getParent().getHeight());
                this.scrollRectToVisible(markerPosition);
            }
        });
    }

    private void copyMarkers() {
        if (this.plugin.copyMarkers() != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.plugin.copyMarkers()), null);
        }
    }

    private void pasteMarkers() {
        String clipboardText;
        try {
            clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException ignore) {
            return;
        }
        if (this.plugin.pasteMarkers(clipboardText)) {
            this.noMarkersPanel.setVisible(false);
            this.searchPanel.setVisible(true);
            this.rebuild();
        }
    }

    public PanelFilter getPanelFilter() {
        return this.panelFilter;
    }

    static {
        FILTER_TEXT = new String[]{"ALL", "R", "", ""};
        BufferedImage copyIcon = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "copy_icon.png");
        COPY_ICON = new ImageIcon(copyIcon);
        COPY_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)copyIcon, 0.53f));
        BufferedImage pasteIcon = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "paste_icon.png");
        PASTE_ICON = new ImageIcon(pasteIcon);
        PASTE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)pasteIcon, 0.53f));
        BufferedImage addIcon = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, 0.53f));
        BufferedImage visibleImg = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "visible_icon.png");
        BufferedImage invisibleImg = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "invisible_icon.png");
        BufferedImage regionIcon = ImageUtil.loadImageResource(RadiusMarkerPlugin.class, "region_icon.png");
        FILTER_ICONS = new ImageIcon[]{new ImageIcon(ImageUtil.alphaOffset((Image)visibleImg, 0.0f)), new ImageIcon(regionIcon), new ImageIcon(visibleImg), new ImageIcon(invisibleImg)};
        FILTER_DESCRIPTIONS = new String[]{"<html>Filter:<br>Listing all markers</html>", "<html>Filter:<br>Listing only markers in the current region</html>", "<html>Filter:<br>Listing only visible markers</html>", "<html>Filter:<br>Listing only hidden markers</html>"};
    }
}

