/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public interface InterruptSource {
    public Throwable getInterruptSource(boolean var1);

    public int getInterruptCounter(boolean var1);

    public void clearInterruptSource();

    public static class Thread
    extends java.lang.Thread
    implements InterruptSource {
        volatile Throwable interruptSource = null;
        volatile int interruptCounter = 0;
        final Object sync = new Object();

        public Thread() {
        }

        public Thread(ThreadGroup threadGroup, Runnable runnable2) {
            super(threadGroup, runnable2);
        }

        public Thread(ThreadGroup threadGroup, Runnable runnable2, String string) {
            super(threadGroup, runnable2, string);
        }

        public static Thread create(ThreadGroup threadGroup, Runnable runnable2, String string) {
            return null != string ? new Thread(threadGroup, runnable2, string) : new Thread(threadGroup, runnable2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Throwable getInterruptSource(boolean bl) {
            Object object = this.sync;
            synchronized (object) {
                Throwable throwable = this.interruptSource;
                if (bl) {
                    this.clearInterruptSource();
                }
                return throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int getInterruptCounter(boolean bl) {
            Object object = this.sync;
            synchronized (object) {
                int n = this.interruptCounter;
                if (bl) {
                    this.clearInterruptSource();
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clearInterruptSource() {
            Object object = this.sync;
            synchronized (object) {
                this.interruptCounter = 0;
                this.interruptSource = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void interrupt() {
            Object object = this.sync;
            synchronized (object) {
                ++this.interruptCounter;
                this.interruptSource = new Throwable(this.getName() + ".interrupt() #" + this.interruptCounter);
            }
            super.interrupt();
        }
    }

    public static class Util {
        public static InterruptSource get(java.lang.Thread thread2) {
            if (thread2 instanceof InterruptSource) {
                return (InterruptSource)((Object)thread2);
            }
            return null;
        }

        public static InterruptSource currentThread() {
            return Util.get(java.lang.Thread.currentThread());
        }
    }
}

