/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.common.util.ValueConv;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class Buffers {
    static final boolean DEBUG = Debug.debug("Buffers");
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int n) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(n));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n, int n2) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(n2).put(byArray, n, n2).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n) {
        return Buffers.newDirectByteBuffer(byArray, n, byArray.length - n);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return Buffers.newDirectByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n, int n2) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(n2).put(dArray, n, n2).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n) {
        return Buffers.newDirectDoubleBuffer(dArray, n, dArray.length - n);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return Buffers.newDirectDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n, int n2) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(n2).put(fArray, n, n2).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n) {
        return Buffers.newDirectFloatBuffer(fArray, n, fArray.length - n);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return Buffers.newDirectFloatBuffer(fArray, 0);
    }

    public static IntBuffer newDirectIntBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n, int n2) {
        return (IntBuffer)Buffers.newDirectIntBuffer(n2).put(nArray, n, n2).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n) {
        return Buffers.newDirectIntBuffer(nArray, n, nArray.length - n);
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray) {
        return Buffers.newDirectIntBuffer(nArray, 0);
    }

    public static LongBuffer newDirectLongBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n, int n2) {
        return (LongBuffer)Buffers.newDirectLongBuffer(n2).put(lArray, n, n2).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n) {
        return Buffers.newDirectLongBuffer(lArray, n, lArray.length - n);
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray) {
        return Buffers.newDirectLongBuffer(lArray, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n, int n2) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(n2).put(sArray, n, n2).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n) {
        return Buffers.newDirectShortBuffer(sArray, n, sArray.length - n);
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray) {
        return Buffers.newDirectShortBuffer(sArray, 0);
    }

    public static CharBuffer newDirectCharBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n, int n2) {
        return (CharBuffer)Buffers.newDirectCharBuffer(n2).put(cArray, n, n2).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n) {
        return Buffers.newDirectCharBuffer(cArray, n, cArray.length - n);
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray) {
        return Buffers.newDirectCharBuffer(cArray, 0);
    }

    public static <B extends Buffer> B slice(B b) {
        if (b instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b;
            return (B)byteBuffer.slice().order(byteBuffer.order());
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).slice();
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).slice();
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).slice();
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).slice();
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).slice();
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).slice();
        }
        throw new IllegalArgumentException("unexpected buffer type: " + b.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B extends Buffer> B slice(B b, int n, int n2) {
        int n3 = b.position();
        int n4 = b.limit();
        B b2 = null;
        try {
            b.position(n).limit(n + n2);
            b2 = Buffers.slice(b);
        }
        finally {
            b.position(n3).limit(n4);
        }
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FloatBuffer slice2Float(Buffer buffer, int n, int n2) {
        FloatBuffer floatBuffer;
        block8: {
            int n3;
            int n4;
            if (null != buffer) {
                n4 = buffer.position();
                n3 = buffer.limit();
            } else {
                n4 = 0;
                n3 = 0;
            }
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 4);
                    byteBuffer.limit((n + n2) * 4);
                    floatBuffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                    break block8;
                }
                if (buffer instanceof FloatBuffer) {
                    FloatBuffer floatBuffer2 = (FloatBuffer)buffer;
                    floatBuffer2.position(n);
                    floatBuffer2.limit(n + n2);
                    floatBuffer = floatBuffer2.slice();
                    break block8;
                }
                throw new InternalError("Buffer not ByteBuffer, nor FloarBuffer, nor backing array given");
            }
            finally {
                if (null != buffer) {
                    buffer.position(n4).limit(n3);
                }
            }
        }
        floatBuffer.mark();
        return floatBuffer;
    }

    public static final FloatBuffer slice2Float(float[] fArray, int n, int n2) {
        return (FloatBuffer)FloatBuffer.wrap(fArray, n, n2).mark();
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static int sizeOfBufferElem(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ByteBuffer) {
            return 1;
        }
        if (object instanceof IntBuffer) {
            return 4;
        }
        if (object instanceof ShortBuffer) {
            return 2;
        }
        if (object instanceof FloatBuffer) {
            return 4;
        }
        if (object instanceof DoubleBuffer) {
            return 8;
        }
        if (object instanceof LongBuffer) {
            return 8;
        }
        if (object instanceof CharBuffer) {
            return 2;
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).elementSize();
        }
        throw new RuntimeException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int remainingElem(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).remaining();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).remaining();
        }
        throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int remainingBytes(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (!(object instanceof CharBuffer)) throw new InternalError("Unsupported Buffer type: " + object.getClass().getCanonicalName());
            return n * 2;
        }
        if (!(object instanceof NativeBuffer)) throw new IllegalArgumentException("Unsupported anonymous buffer type: " + object.getClass().getCanonicalName());
        NativeBuffer nativeBuffer = (NativeBuffer)object;
        return nativeBuffer.remaining() * nativeBuffer.elementSize();
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        throw new IllegalArgumentException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (object instanceof CharBuffer) {
                return n * 2;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.position() * nativeBuffer.elementSize();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static Object getArray(Object object) throws UnsupportedOperationException, IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).array();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).array();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n);
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.elementSize() * (nativeBuffer.arrayOffset() + nativeBuffer.position());
        }
        throw new IllegalArgumentException("Unknown buffer type " + object.getClass().getName());
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        byteBuffer.position(n);
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return Buffers.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return Buffers.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return Buffers.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        floatBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        int n = intBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        intBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        int n = shortBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        shortBuffer.position(n);
        return byteBuffer;
    }

    public static float[] getFloatArray(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (0 > n3) {
            n3 = dArray.length - n;
        }
        if (n3 > dArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + dArray.length + ", offset " + n + "]");
        }
        if (null == fArray) {
            fArray = new float[n3];
            n2 = 0;
        }
        if (n3 > fArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + fArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2 + i] = (float)dArray[n + i];
        }
        return fArray;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer, FloatBuffer floatBuffer) {
        if (null == floatBuffer) {
            floatBuffer = Buffers.newDirectFloatBuffer(doubleBuffer.remaining());
        }
        if (floatBuffer.remaining() < doubleBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + doubleBuffer.remaining() + ") is greater than remaining dest bytes: " + floatBuffer.remaining());
        }
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static double[] getDoubleArray(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (0 > n3) {
            n3 = fArray.length - n;
        }
        if (n3 > fArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + fArray.length + ", offset " + n + "]");
        }
        if (null == dArray) {
            dArray = new double[n3];
            n2 = 0;
        }
        if (n3 > dArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + dArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            dArray[n2 + i] = fArray[n + i];
        }
        return dArray;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (null == doubleBuffer) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(floatBuffer.remaining());
        }
        if (doubleBuffer.remaining() < floatBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + floatBuffer.remaining() + ") is greater than remaining dest bytes: " + doubleBuffer.remaining());
        }
        while (floatBuffer.hasRemaining()) {
            doubleBuffer.put(floatBuffer.get());
        }
        return doubleBuffer;
    }

    public static <B extends Buffer> B put(B b, Buffer buffer) {
        if (b instanceof ByteBuffer && buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put((ByteBuffer)buffer);
        }
        if (b instanceof ShortBuffer && buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put((ShortBuffer)buffer);
        }
        if (b instanceof IntBuffer && buffer instanceof IntBuffer) {
            return (B)((IntBuffer)b).put((IntBuffer)buffer);
        }
        if (b instanceof FloatBuffer && buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((FloatBuffer)buffer);
        }
        if (b instanceof LongBuffer && buffer instanceof LongBuffer) {
            return (B)((LongBuffer)b).put((LongBuffer)buffer);
        }
        if (b instanceof DoubleBuffer && buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put((DoubleBuffer)buffer);
        }
        if (b instanceof CharBuffer && buffer instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((CharBuffer)buffer);
        }
        throw new IllegalArgumentException("Incompatible Buffer classes: dest = " + b.getClass().getName() + ", src = " + buffer.getClass().getName());
    }

    public static <B extends Buffer> B putb(B b, byte by) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(by);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(by);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(by);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(by);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(by);
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((char)by);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puts(B b, short s2) {
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s2);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(s2);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(s2);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(s2);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(s2);
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puti(B b, int n) {
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(n);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(n);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(n);
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putf(B b, float f) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putd(B b, double d) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((float)d);
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNb(B b, boolean bl, byte by, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.byte_to_short(by, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.byte_to_int(by, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.byte_to_float(by, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNs(B b, boolean bl, short s2, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.short_to_byte(s2, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s2);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.short_to_int(s2, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.short_to_float(s2, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNi(B b, boolean bl, int n, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.int_to_byte(n, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.int_to_short(n, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.int_to_float(n, bl2));
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putNf(B b, boolean bl, float f) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.float_to_byte(f, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.float_to_short(f, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.float_to_int(f, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (byArray.length - n));
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (cArray.length - n));
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (sArray.length - n));
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (nArray.length - n));
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (lArray.length - n));
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (fArray.length - n));
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (dArray.length - n));
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object object, int n) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (object == null) {
            return;
        }
        int n2 = Buffers.remainingBytes(object);
        if (n2 < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining bytes in buffer, only had " + n2);
        }
    }

    public static StringBuilder toString(StringBuilder stringBuilder, String string, Buffer buffer) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(buffer.getClass().getSimpleName());
        stringBuilder.append("[pos ").append(buffer.position()).append(", lim ").append(buffer.limit()).append(", cap ").append(buffer.capacity());
        stringBuilder.append(", remaining ").append(buffer.remaining());
        stringBuilder.append("; array ").append(buffer.hasArray()).append(", direct ").append(buffer.isDirect());
        stringBuilder.append(", r/w ").append(!buffer.isReadOnly()).append(": ");
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(byteBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, byteBuffer.get(i)));
            }
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            for (int i = 0; i < floatBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(floatBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Float.valueOf(floatBuffer.get(i))));
            }
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            for (int i = 0; i < intBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(intBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, intBuffer.get(i)));
            }
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            for (int i = 0; i < shortBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(shortBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, shortBuffer.get(i)));
            }
        } else if (buffer instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)buffer;
            for (int i = 0; i < doubleBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(doubleBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, doubleBuffer.get(i)));
            }
        } else if (buffer instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)buffer;
            for (int i = 0; i < longBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(longBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, longBuffer.get(i)));
            }
        } else if (buffer instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)buffer;
            for (int i = 0; i < charBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(charBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Character.valueOf(charBuffer.get(i))));
            }
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public static class Cleaner {
        private static final Method mbbCleaner;
        private static final Method cClean;
        private static volatile boolean cleanerError;

        public static boolean clean(ByteBuffer byteBuffer) {
            if (cleanerError || !byteBuffer.isDirect()) {
                return false;
            }
            try {
                if (PlatformPropsImpl.JAVA_9) {
                    UnsafeUtil.invokeCleaner(byteBuffer);
                } else {
                    cClean.invoke(mbbCleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                }
                return true;
            }
            catch (Throwable throwable) {
                cleanerError = true;
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("Buffers", throwable);
                }
                return false;
            }
        }

        static {
            boolean bl;
            final Method[] methodArray = new Method[]{null};
            final Method[] methodArray2 = new Method[]{null};
            if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        if (PlatformPropsImpl.JAVA_9) {
                            return UnsafeUtil.hasInvokeCleaner();
                        }
                        methodArray[0] = ReflectionUtil.getMethod("sun.nio.ch.DirectBuffer", "cleaner", null, Buffers.class.getClassLoader());
                        methodArray[0].setAccessible(true);
                        Class<?> clazz = methodArray[0].getReturnType();
                        methodArray2[0] = clazz.getMethod("clean", new Class[0]);
                        methodArray2[0].setAccessible(true);
                        return Boolean.TRUE;
                    }
                    catch (Throwable throwable) {
                        if (DEBUG) {
                            ExceptionUtils.dumpThrowable("Buffers", throwable);
                        }
                        return Boolean.FALSE;
                    }
                }
            }).booleanValue()) {
                mbbCleaner = methodArray[0];
                cClean = methodArray2[0];
                bl = PlatformPropsImpl.JAVA_9 || null != mbbCleaner && null != cClean;
            } else {
                mbbCleaner = null;
                cClean = null;
                bl = false;
            }
            boolean bl2 = cleanerError = !bl;
            if (DEBUG) {
                System.err.print("Buffers.Cleaner.init: hasCleaner: " + bl + ", cleanerError " + cleanerError);
                if (null != mbbCleaner) {
                    System.err.print(", using Cleaner class: " + mbbCleaner.getReturnType().getName());
                }
                System.err.println();
            }
        }
    }
}

