/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GroundObject;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdditionPuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(AdditionPuzzleSolver.class);
    private static final Set<Integer> GAME_OBJECT_IDS = Arrays.stream(AdditionTile.values()).map(AdditionTile::getGameObjectId).collect(Collectors.toSet());
    private static final Point[] SCENE_COORD_STARTS = new Point[]{new Point(36, 56), new Point(36, 44), new Point(53, 56), new Point(53, 44)};
    private static final Map<Integer, Set<Integer>> OPTIMAL_SOLUTIONS = ImmutableMap.builder().put(20, ImmutableSet.of(Integer.valueOf(5), Integer.valueOf(11), Integer.valueOf(17))).put(21, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(17))).put(22, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(18), Integer.valueOf(24))).put(23, ImmutableSet.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(14))).put(24, ImmutableSet.of(Integer.valueOf(5), Integer.valueOf(11), Integer.valueOf(17), Integer.valueOf(23))).put(25, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13))).put(26, ImmutableSet.of(Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13))).put(27, ImmutableSet.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(4))).put(28, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(13), Integer.valueOf(19))).put(29, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(19))).put(30, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14))).put(31, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(6), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14))).put(32, ImmutableSet.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(10))).put(33, ImmutableSet.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), new Integer[]{14})).put(34, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(19), new Integer[0])).put(35, ImmutableSet.of(Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), new Integer[]{19})).put(36, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(9), new Integer[]{14})).put(37, ImmutableSet.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(19), new Integer[]{24})).put(38, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(10), Integer.valueOf(12), Integer.valueOf(18), new Integer[]{24})).put(39, ImmutableSet.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(7), Integer.valueOf(10), Integer.valueOf(11), new Integer[]{12})).put(40, ImmutableSet.of(Integer.valueOf(4), Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), new Integer[]{14})).put(41, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(12), Integer.valueOf(13), new Integer[]{14})).put(42, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), new Integer[]{13})).put(43, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(10), Integer.valueOf(13), new Integer[]{19})).put(44, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(14), Integer.valueOf(17), new Integer[]{18})).put(45, ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), new Integer[]{10})).build();
    private static final Pattern TARGET_NUMBER_PATTERN = Pattern.compile("The number (\\d+) has been hastily chipped into the stone.");
    private final EventBus eventBus;
    private final Client client;
    private boolean solved;
    private Set<Integer> tileStates;
    private int targetNumber;
    private Set<LocalPoint> flips = Collections.emptySet();

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
        this.targetNumber = 0;
        this.solved = false;
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (GAME_OBJECT_IDS.contains(e.getGameObject().getId())) {
            this.solved = false;
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (GAME_OBJECT_IDS.contains(e.getGameObject().getId())) {
            this.solved = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        if (!this.solved) {
            this.solve();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.targetNumber = 0;
            this.solved = false;
            return;
        }
        Matcher matcher = TARGET_NUMBER_PATTERN.matcher(Text.removeTags(e.getMessage()));
        if (!matcher.matches()) {
            return;
        }
        this.targetNumber = Integer.parseInt(matcher.group(1));
        this.solve();
    }

    private void solve() {
        this.solved = true;
        if (this.targetNumber < 20) {
            return;
        }
        Tile[][] sceneTiles = this.client.getScene().getTiles()[this.client.getPlane()];
        Point tl = this.findStartTile(sceneTiles);
        if (tl == null) {
            log.debug("Failed to locate start of addition puzzle");
            return;
        }
        this.tileStates = this.readTileStates(sceneTiles, tl);
        this.flips = this.findSolution(tl);
    }

    private Point findStartTile(Tile[][] sceneTiles) {
        for (Point sceneCoordStart : SCENE_COORD_STARTS) {
            Tile startTile = sceneTiles[sceneCoordStart.getX()][sceneCoordStart.getY()];
            GroundObject groundObject = startTile.getGroundObject();
            if (groundObject == null || groundObject.getId() != AdditionTile.FOOT.getGroundObjectId()) continue;
            return sceneCoordStart;
        }
        return null;
    }

    private Set<Integer> readTileStates(Tile[][] sceneTiles, Point topLeft) {
        HashSet<Integer> tileStates = new HashSet<Integer>();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                Tile additionTile = sceneTiles[topLeft.getX() + x][topLeft.getY() - y];
                boolean active = Arrays.stream(additionTile.getGameObjects()).filter(Objects::nonNull).mapToInt(TileObject::getId).anyMatch(GAME_OBJECT_IDS::contains);
                if (!active) continue;
                tileStates.add(y * 5 + x);
            }
        }
        return tileStates;
    }

    private Set<LocalPoint> findSolution(Point topLeft) {
        Sets.SetView<Integer> remaining = Sets.difference(OPTIMAL_SOLUTIONS.get(this.targetNumber), this.tileStates);
        return remaining.stream().map(i -> LocalPoint.fromScene(topLeft.getX() + i % 5, topLeft.getY() - i / 5)).collect(Collectors.toSet());
    }

    @Inject
    public AdditionPuzzleSolver(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
    }

    public Set<LocalPoint> getFlips() {
        return this.flips;
    }

    static enum AdditionTile {
        LINE(1, 45345, 45388),
        KNIVES(2, 45346, 45389),
        TRIANGLE(3, 45347, 45390),
        DIAMOND(4, 45348, 45391),
        HAND(5, 45349, 45392),
        BIRD(6, 45350, 45393),
        CROOK(7, 45351, 45386),
        WIGGLE(8, 45352, 45394),
        FOOT(9, 45353, 45395);

        private final int value;
        private final int groundObjectId;
        private final int gameObjectId;

        private AdditionTile(int value, int groundObjectId, int gameObjectId) {
            this.value = value;
            this.groundObjectId = groundObjectId;
            this.gameObjectId = gameObjectId;
        }

        public int getValue() {
            return this.value;
        }

        public int getGroundObjectId() {
            return this.groundObjectId;
        }

        public int getGameObjectId() {
            return this.gameObjectId;
        }
    }
}

