/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.pointstracker;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.pointstracker.PointsMessage;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserJoin;
import net.runelite.client.party.events.UserPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PartyPointsTracker
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(PartyPointsTracker.class);
    private final WSClient wsClient;
    private final EventBus eventBus;
    private final PartyService partyService;
    private final ScheduledExecutorService partySendEs;
    private final Map<Long, Integer> partyPoints = new HashMap<Long, Integer>();
    private final AtomicInteger partySequenceId = new AtomicInteger(0);
    private long partyDontSendUntil = -1L;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.isInRaid();
    }

    @Override
    public void startUp() {
        this.wsClient.registerMessage(PointsMessage.class);
        this.eventBus.register(this);
        this.clearPartyPointsMap();
    }

    @Override
    public void shutDown() {
        this.wsClient.unregisterMessage(PointsMessage.class);
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onPointsMessage(PointsMessage e) {
        this.partyPoints.put(e.getMemberId(), e.getPoints());
    }

    @Subscribe
    public void onUserJoin(UserJoin e) {
        this.partyPoints.remove(e.getMemberId());
    }

    @Subscribe
    public void onUserPart(UserPart e) {
        this.partyPoints.remove(e.getMemberId());
    }

    @Subscribe
    public void onPartyChanged(PartyChanged e) {
        this.clearPartyPointsMap();
    }

    public void schedulePointsUpdate(int points) {
        if (!this.isInParty()) {
            return;
        }
        int thisReqId = this.partySequenceId.incrementAndGet();
        this.partySendEs.schedule(() -> {
            if (thisReqId != this.partySequenceId.get()) {
                return;
            }
            this.sendPointsUpdate(points);
        }, Math.max(0L, this.partyDontSendUntil - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
    }

    public void sendPointsUpdate(int points) {
        if (!this.isInParty()) {
            return;
        }
        PointsMessage message = new PointsMessage(points);
        this.partyService.send(message);
        this.partyDontSendUntil = System.currentTimeMillis() + 30000L;
    }

    public void clearPartyPointsMap() {
        this.partyPoints.clear();
    }

    public int getTotalPartyPoints() {
        return this.partyPoints.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean isInParty() {
        return this.partyService.isInParty();
    }

    @Inject
    public PartyPointsTracker(WSClient wsClient, EventBus eventBus, PartyService partyService, ScheduledExecutorService partySendEs) {
        this.wsClient = wsClient;
        this.eventBus = eventBus;
        this.partyService = partyService;
        this.partySendEs = partySendEs;
    }
}

