/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QuickProceedSwaps
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(QuickProceedSwaps.class);
    private static final Set<Integer> NPC_IDS = ImmutableSet.of(Integer.valueOf(11689), Integer.valueOf(11690), Integer.valueOf(11693));
    private static final Set<Integer> OBJECT_IDS = ImmutableSet.of(Integer.valueOf(46161), Integer.valueOf(46155), Integer.valueOf(46164), Integer.valueOf(46158), Integer.valueOf(45135), Integer.valueOf(45505), new Integer[]{45506, 45866, 45754, 45131, 45337, 45397, 45500, 46168});
    private final EventBus eventBus;
    private final TombsOfAmascutConfig config;
    private final RaidStateTracker raidStateTracker;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.isInRaid() && config.quickProceedEnableMode() != QuickProceedEnableMode.NONE;
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        MenuEntry me = e.getMenuEntry();
        if (this.shouldDeprioritize(me)) {
            me.setDeprioritized(true);
        }
    }

    private boolean shouldDeprioritize(MenuEntry me) {
        switch (me.getType()) {
            case NPC_FIRST_OPTION: {
                return me.getOption().equals("Talk-to") && me.getNpc() != null && NPC_IDS.contains(me.getNpc().getId());
            }
            case GAME_OBJECT_FIRST_OPTION: {
                int id = me.getIdentifier();
                String option = me.getOption();
                if (id == 45135 && this.raidStateTracker.getCurrentState().getCurrentRoom() == RaidRoom.CRONDIS && option.equals("Pass")) {
                    return this.config.quickProceedEnableMode() != QuickProceedEnableMode.NOT_CRONDIS;
                }
                return OBJECT_IDS.contains(id) && (option.equals("Enter") || option.equals("Use") || option.equals("Pass"));
            }
        }
        return false;
    }

    @Inject
    public QuickProceedSwaps(EventBus eventBus, TombsOfAmascutConfig config, RaidStateTracker raidStateTracker) {
        this.eventBus = eventBus;
        this.config = config;
        this.raidStateTracker = raidStateTracker;
    }

    public static enum QuickProceedEnableMode {
        ALL,
        NOT_CRONDIS,
        NONE;

    }
}

