/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.boss;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.module.Module;
import ca.gauntlet.module.boss.BossOverlay;
import ca.gauntlet.module.overlay.TimerOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.ui.overlay.OverlayManager;

@Singleton
public final class BossModule
implements Module {
    private static final List<Integer> TORNADO_IDS = List.of(Integer.valueOf(9025), Integer.valueOf(9039));
    private final Function<NPC, HighlightedNpc> npcHighlighter = this::highlightNpc;
    private final List<NPC> tornadoes = new ArrayList<NPC>();
    @Inject
    private EventBus eventBus;
    @Inject
    private Client client;
    @Inject
    private TheGauntletConfig config;
    @Inject
    private NpcOverlayService npcOverlayService;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TimerOverlay timerOverlay;
    @Inject
    private BossOverlay bossOverlay;

    @Override
    public void start() {
        this.eventBus.register(this);
        this.npcOverlayService.registerHighlighter(this.npcHighlighter);
        this.overlayManager.add(this.timerOverlay);
        this.overlayManager.add(this.bossOverlay);
        this.timerOverlay.setHunllefStart();
    }

    @Override
    public void stop() {
        this.eventBus.unregister(this);
        this.npcOverlayService.unregisterHighlighter(this.npcHighlighter);
        this.overlayManager.remove(this.timerOverlay);
        this.overlayManager.remove(this.bossOverlay);
        this.timerOverlay.reset();
        this.tornadoes.clear();
    }

    @Subscribe
    void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.stop();
            }
        }
    }

    @Subscribe
    void onActorDeath(ActorDeath event) {
        if (event.getActor() == this.client.getLocalPlayer()) {
            this.timerOverlay.onPlayerDeath();
        }
    }

    @Subscribe
    void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (TORNADO_IDS.contains(npc.getId())) {
            this.tornadoes.add(npc);
        }
    }

    @Subscribe
    void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        if (TORNADO_IDS.contains(npc.getId())) {
            this.tornadoes.removeIf(t -> t == npc);
        }
    }

    private HighlightedNpc highlightNpc(NPC npc) {
        int id = npc.getId();
        switch (id) {
            case 9021: 
            case 9022: 
            case 9023: 
            case 9024: 
            case 9035: 
            case 9036: 
            case 9037: 
            case 9038: {
                return HighlightedNpc.builder().npc(npc).tile(true).borderWidth(this.config.hunllefTileOutlineWidth()).fillColor(this.config.hunllefFillColor()).highlightColor(this.config.hunllefOutlineColor()).render(n -> this.config.hunllefTileOutline() && !npc.isDead()).build();
            }
        }
        return null;
    }

    List<NPC> getTornadoes() {
        return this.tornadoes;
    }
}

