/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windbg;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.CDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LineNumberInfo;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.win32.coff.COFFException;
import sun.jvm.hotspot.debugger.win32.coff.COFFFile;
import sun.jvm.hotspot.debugger.win32.coff.COFFFileParser;
import sun.jvm.hotspot.debugger.win32.coff.ExportDirectoryTable;
import sun.jvm.hotspot.debugger.windbg.AddressDataSource;
import sun.jvm.hotspot.debugger.windbg.WindbgCDebugInfoBuilder;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.memo.MemoizedObject;

public class DLL
implements LoadObject {
    private WindbgDebugger dbg;
    private String fullPathName;
    private long size;
    private MemoizedObject file;
    private Address addr;
    private CDebugInfoDataBase db;

    public DLL(WindbgDebugger dbg, String filename, long size, Address relocation) throws COFFException {
        this.dbg = dbg;
        this.fullPathName = filename;
        this.size = size;
        this.file = new MemoizedObject(){

            @Override
            public Object computeValue() {
                return COFFFileParser.getParser().parse(DLL.this.fullPathName);
            }
        };
        this.addr = relocation;
    }

    public DLL(Address base) throws COFFException {
        this.addr = base;
        this.file = new MemoizedObject(){

            @Override
            public Object computeValue() {
                return COFFFileParser.getParser().parse(new AddressDataSource(DLL.this.addr));
            }
        };
    }

    public boolean isDLL() {
        return this.getFile().getHeader().hasCharacteristic((short)8192);
    }

    public Address lookupSymbol(String symbol) throws COFFException {
        if (!this.isDLL()) {
            return null;
        }
        ExportDirectoryTable exports = this.getExportDirectoryTable();
        return this.lookupSymbol(symbol, exports, 0, exports.getNumberOfNamePointers() - 1);
    }

    @Override
    public Address getBase() {
        return this.addr;
    }

    @Override
    public String getName() {
        return this.fullPathName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public CDebugInfoDataBase getDebugInfoDataBase() throws DebuggerException {
        if (this.db != null) {
            return this.db;
        }
        if (this.dbg == null) {
            return null;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.fullPathName != null, "Need full path name to build debug info database");
        }
        this.db = new WindbgCDebugInfoBuilder(this.dbg).buildDataBase(this.fullPathName, this.addr);
        return this.db;
    }

    @Override
    public BlockSym debugInfoForPC(Address pc) throws DebuggerException {
        CDebugInfoDataBase db = this.getDebugInfoDataBase();
        if (db == null) {
            return null;
        }
        return db.debugInfoForPC(pc);
    }

    @Override
    public ClosestSymbol closestSymbolToPC(Address pcAsAddr) throws DebuggerException {
        ExportDirectoryTable exports = this.getExportDirectoryTable();
        if (exports == null) {
            return null;
        }
        String name = null;
        long pc = this.dbg.getAddressValue(pcAsAddr);
        long diff = Long.MAX_VALUE;
        long base = this.dbg.getAddressValue(this.addr);
        for (int i = 0; i < exports.getNumberOfNamePointers(); ++i) {
            long tmp;
            if (exports.isExportAddressForwarder(exports.getExportOrdinal(i)) || (tmp = base + (long)(exports.getExportAddress(exports.getExportOrdinal(i)) & 0xFFFFFFFF)) > pc || pc - tmp >= diff) continue;
            diff = pc - tmp;
            name = exports.getExportName(i);
        }
        if (name == null) {
            return null;
        }
        return new ClosestSymbol(name, diff);
    }

    @Override
    public LineNumberInfo lineNumberForPC(Address pc) throws DebuggerException {
        CDebugInfoDataBase db = this.getDebugInfoDataBase();
        if (db == null) {
            return null;
        }
        return db.lineNumberForPC(pc);
    }

    public void close() {
        this.getFile().close();
        this.file = null;
    }

    private COFFFile getFile() {
        return (COFFFile)this.file.getValue();
    }

    private Address lookupSymbol(String symbol, ExportDirectoryTable exports, int loIdx, int hiIdx) {
        do {
            int curIdx;
            String cur;
            if (symbol.equals(cur = exports.getExportName(curIdx = loIdx + hiIdx >> 1))) {
                return this.addr.addOffsetTo((long)exports.getExportAddress(exports.getExportOrdinal(curIdx)) & 0xFFFFFFFFL);
            }
            if (symbol.compareTo(cur) < 0) {
                if (hiIdx == curIdx) {
                    hiIdx = curIdx - 1;
                    continue;
                }
                hiIdx = curIdx;
                continue;
            }
            loIdx = loIdx == curIdx ? curIdx + 1 : curIdx;
        } while (loIdx <= hiIdx);
        return null;
    }

    private ExportDirectoryTable getExportDirectoryTable() {
        return this.getFile().getHeader().getOptionalHeader().getDataDirectories().getExportDirectoryTable();
    }
}

