/*
 * Decompiled with CFR 0.152.
 */
package org.launch;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.launch.Binder;
import org.launch.Settings;
import org.launch.download.DownloadManager;
import org.launch.frame.Frame;

public class Launch {
    private static Injector injector;
    @Inject
    private Frame frame;
    @Inject
    private DownloadManager downloadManager;
    @Inject
    private Settings settings;

    public static void main(String[] args) {
        injector = Guice.createInjector(new Binder());
        injector.getInstance(Launch.class).start();
    }

    public void start() {
        this.settings.setOperatingSystem();
        this.frame.setVisible(true);
        File dir = new File(this.settings.getGameDirectory());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Thread.sleep(300L);
        this.downloadManager.init();
        switch (this.settings.getOperatingSystem()) {
            case WINDOWS: {
                this.settings.launchGame("windows/bin", "javaw.exe");
                break;
            }
            case MAC: {
                this.settings.launchGame("mac/Contents/Home/bin", "java");
                break;
            }
            case LINUX: {
                this.settings.launchGame("linux/bin", "java");
            }
        }
    }

    public static Injector getInjector() {
        return injector;
    }
}

