/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HDUtils {
    private static final Logger log = LoggerFactory.getLogger(HDUtils.class);
    private static final float[] inverseLightDirectionZ0 = new float[]{0.70710677f, 0.70710677f, 0.0f};
    private static final float[] inverseLightDirectionZ1 = new float[]{0.57735026f, 0.57735026f, 0.57735026f};
    private static final float EPSILON = 1.1920929E-7f;

    public static float[] vectorAdd(float[] vec1, float[] vec2) {
        float[] out = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static float[] vectorAdd(float[] vec1, int[] vec2) {
        float[] out = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + (float)vec2[i];
        }
        return out;
    }

    static int[] vectorAdd(int[] vec1, int[] vec2) {
        int[] out = new int[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static double[] vectorAdd(double[] vec1, double[] vec2) {
        double[] out = new double[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static Double[] vectorAdd(Double[] vec1, Double[] vec2) {
        Double[] out = new Double[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static float[] vectorDivide(float[] vec1, float divide) {
        float[] out = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = divide == 0.0f ? 0.0f : vec1[i] / divide;
        }
        return out;
    }

    public static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static float[] lerpVectors(float[] vecA, float[] vecB, float t) {
        float[] out = new float[Math.min(vecA.length, vecB.length)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = HDUtils.lerp(vecA[i], vecB[i], t);
        }
        return out;
    }

    static int[] lerpVectors(int[] vecA, int[] vecB, float t) {
        int[] out = new int[Math.min(vecA.length, vecB.length)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (int)HDUtils.lerp(vecA[i], vecB[i], t);
        }
        return out;
    }

    public static int clamp(int value, int min2, int max) {
        return Math.min(max, Math.max(min2, value));
    }

    public static float clamp(float value, float min2, float max) {
        return Math.min(max, Math.max(min2, value));
    }

    public static int vertexHash(int[] vPos) {
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < vPos.length; ++i) {
            s2.append(vPos[i]).append(",");
        }
        return s2.toString().hashCode();
    }

    public static float[] calculateSurfaceNormals(int[] vertexX, int[] vertexY, int[] vertexZ) {
        float[] a = new float[]{vertexX[0] - vertexX[1], vertexY[0] - vertexY[1], vertexZ[0] - vertexZ[1]};
        float[] b = new float[]{vertexX[0] - vertexX[2], vertexY[0] - vertexY[2], vertexZ[0] - vertexZ[2]};
        float[] n = new float[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        return n;
    }

    public static int[] colorIntToHSL(int colorInt) {
        int[] outHSL = new int[]{colorInt >> 10 & 0x3F, colorInt >> 7 & 7, colorInt & 0x7F};
        return outHSL;
    }

    public static int colorHSLToInt(int[] colorHSL) {
        return (colorHSL[0] << 3 | colorHSL[1]) << 7 | colorHSL[2];
    }

    public static int[] colorIntToRGB(int colorInt) {
        int[] outHSL = new int[]{colorInt >> 10 & 0x3F, colorInt >> 7 & 7, colorInt & 0x7F};
        return HDUtils.colorHSLToRGB(outHSL[0], outHSL[1], outHSL[2]);
    }

    public static int colorRGBToInt(float[] colorRGB) {
        int[] colorRGBInt = new int[3];
        for (int i = 0; i < colorRGB.length; ++i) {
            colorRGBInt[i] = (int)(colorRGB[i] * 255.0f);
        }
        return (colorRGBInt[0] << 8 | colorRGBInt[1]) << 8 | colorRGBInt[2] | 0x8000000;
    }

    static int[] colorHSLToRGB(float h2, float s2, float l) {
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s2) : (l /= 128.0f) + (s2 /= 8.0f) - s2 * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, HDUtils.HueToRGB(p, q, (h2 /= 64.0f) + 0.33333334f));
        float g2 = Math.max(0.0f, HDUtils.HueToRGB(p, q, h2));
        float b = Math.max(0.0f, HDUtils.HueToRGB(p, q, h2 - 0.33333334f));
        r = Math.min(r, 1.0f);
        g2 = Math.min(g2, 1.0f);
        b = Math.min(b, 1.0f);
        return new int[]{(int)(r * 255.0f), (int)(g2 * 255.0f), (int)(b * 255.0f)};
    }

    static float HueToRGB(float p, float q, float h2) {
        if (h2 < 0.0f) {
            h2 += 1.0f;
        }
        if (h2 > 1.0f) {
            h2 -= 1.0f;
        }
        if (6.0f * h2 < 1.0f) {
            return p + (q - p) * 6.0f * h2;
        }
        if (2.0f * h2 < 1.0f) {
            return q;
        }
        if (3.0f * h2 < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h2);
        }
        return p;
    }

    public static float linearToSrgb(float c) {
        return (double)c <= 0.0031308 ? c * 12.92f : (float)(1.055 * Math.pow(c, 0.4166666666666667) - 0.055);
    }

    public static float srgbToLinear(float c) {
        return c <= 0.04045f ? c / 12.92f : (float)Math.pow(((double)c + 0.055) / 1.055, 2.4);
    }

    public static float[] linearToSrgb(float[] c) {
        float[] result = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            result[i] = HDUtils.linearToSrgb(c[i]);
        }
        return result;
    }

    public static float[] srgbToLinear(float[] c) {
        float[] result = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            result[i] = HDUtils.srgbToLinear(c[i]);
        }
        return result;
    }

    public static float dotNormal3Lights(float[] normals) {
        return HDUtils.dotNormal3Lights(normals, true);
    }

    public static float dotNormal3Lights(float[] normals, boolean includeZ) {
        float lengthSq = normals[0] * normals[0] + normals[1] * normals[1] + normals[2] * normals[2];
        if (Math.abs(lengthSq) < 1.1920929E-7f) {
            return 0.0f;
        }
        if (includeZ) {
            return (normals[0] * inverseLightDirectionZ1[0] + normals[1] * inverseLightDirectionZ1[1] + normals[2] * inverseLightDirectionZ1[2]) / (float)Math.sqrt(lengthSq);
        }
        return (normals[0] * inverseLightDirectionZ0[0] + normals[1] * inverseLightDirectionZ0[1]) / (float)Math.sqrt(lengthSq);
    }

    public static float[] rgb(int r, int g2, int b) {
        return new float[]{HDUtils.srgbToLinear((float)r / 255.0f), HDUtils.srgbToLinear((float)g2 / 255.0f), HDUtils.srgbToLinear((float)b / 255.0f)};
    }
}

