/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.utils.AABB;
import rs117.hd.utils.Env;
import rs117.hd.utils.ModelHash;
import rs117.hd.utils.ResourcePath;

@Singleton
public class ModelOverrideManager {
    private static final Logger log = LoggerFactory.getLogger(ModelOverrideManager.class);
    private static final String ENV_MODEL_OVERRIDES = "RLHD_MODEL_OVERRIDES_PATH";
    private static final ResourcePath modelOverridesPath = Env.getPathOrDefault("RLHD_MODEL_OVERRIDES_PATH", () -> ResourcePath.path(ModelOverrideManager.class, "model_overrides.json"));
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    private final HashMap<Long, ModelOverride> modelOverrides = new HashMap();
    private final HashMap<Long, AABB[]> modelsToHide = new HashMap();

    public void startUp() {
        this.modelOverrides.clear();
        this.modelsToHide.clear();
        try {
            ModelOverride[] entries = ResourcePath.loadJson(this.getClass().getResourceAsStream("model_overrides.json"), ModelOverride[].class);
            if (entries == null) {
                throw new IOException("Empty or invalid path ");
            }
            for (ModelOverride entry : entries) {
                for (int npcId : entry.npcIds) {
                    this.addEntry(ModelHash.packUuid(npcId, 1), entry);
                }
                for (int objectId : entry.objectIds) {
                    this.addEntry(ModelHash.packUuid(objectId, 2), entry);
                }
            }
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.plugin.reloadScene();
            }
            log.debug("Loaded {} model overrides", (Object)this.modelOverrides.size());
        }
        catch (IOException ex) {
            log.error("Failed to load model overrides:", ex);
        }
    }

    private void addEntry(long uuid, ModelOverride entry) {
        ModelOverride old = this.modelOverrides.put(uuid, entry);
        if (old != null) {
            log.debug("ID {} clashes between entries '{}' and '{}'", ModelHash.getIdOrIndex(uuid), entry.description, old.description);
        }
        this.modelsToHide.put(uuid, entry.hideInAreas);
    }

    public boolean shouldHideModel(long hash, int x, int z) {
        long uuid = ModelHash.getUuid(this.client, hash);
        AABB[] aabbs = this.modelsToHide.get(uuid);
        if (aabbs != null && this.hasNoActions(uuid)) {
            WorldPoint location = ModelHash.getWorldLocation(this.client, x, z);
            for (AABB aabb : aabbs) {
                if (!aabb.contains(location)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNoActions(long uuid) {
        int id = ModelHash.getIdOrIndex(uuid);
        int type = ModelHash.getType(uuid);
        String[] actions = new String[]{};
        switch (type) {
            case 2: {
                actions = this.client.getObjectDefinition(id).getActions();
                break;
            }
            case 1: {
                actions = this.client.getNpcDefinition(id).getActions();
            }
        }
        for (String action : actions) {
            if (action == null) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public ModelOverride getOverride(long hash) {
        return this.modelOverrides.getOrDefault(ModelHash.getUuid(this.client, hash), ModelOverride.NONE);
    }
}

