/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.Player;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.kit.KitType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.data.materials.Material;
import rs117.hd.data.materials.Overlay;
import rs117.hd.data.materials.Underlay;
import rs117.hd.model.ModelCache;
import rs117.hd.model.ModelHasher;
import rs117.hd.scene.ProceduralGenerator;
import rs117.hd.scene.model_overrides.InheritTileColorType;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.scene.model_overrides.ObjectType;
import rs117.hd.scene.model_overrides.TzHaarRecolorType;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.ModelHash;
import rs117.hd.utils.buffer.GpuFloatBuffer;
import rs117.hd.utils.buffer.GpuIntBuffer;

@Singleton
public class ModelPusher {
    private static final Logger log = LoggerFactory.getLogger(ModelPusher.class);
    @Inject
    private HdPlugin hdPlugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private Client client;
    @Inject
    private ProceduralGenerator proceduralGenerator;
    @Inject
    private ModelHasher modelHasher;
    private final ModelCache modelCache = new ModelCache();
    public static final int DATUM_PER_FACE = 12;
    public static final int BYTES_PER_DATUM = 4;
    private boolean started = false;
    private static final int ignoreLowLightness = 3;
    private static final float lightnessMultiplier = 3.0f;
    private static final int baseLighten = 10;
    private static final float[] zeroFloats = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final int[] twoInts = new int[2];
    private static final int[] fourInts = new int[4];
    private static final int[] twelveInts = new int[12];
    private static final float[] twelveFloats = new float[12];

    public void startUp() {
        if (!this.started) {
            this.modelCache.init(this.hdPlugin, this.config);
            this.started = true;
        }
    }

    public void shutDown() {
        if (this.started) {
            this.modelCache.shutDown();
            this.started = false;
        }
    }

    public void clearModelCache() {
        this.modelCache.clear();
    }

    public int[] pushModel(long hash, Model model, GpuIntBuffer vertexBuffer, GpuFloatBuffer uvBuffer, GpuFloatBuffer normalBuffer, int tileX, int tileY, int tileZ, @NonNull ModelOverride modelOverride, ObjectType objectType, boolean noCache) {
        boolean cachingUvData;
        boolean cachingNormalData;
        boolean cachingVertexData;
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        int faceCount = Math.min(model.getFaceCount(), 6144);
        int bufferSize = faceCount * 12;
        int vertexLength = 0;
        int uvLength = 0;
        vertexBuffer.ensureCapacity(bufferSize);
        normalBuffer.ensureCapacity(bufferSize);
        uvBuffer.ensureCapacity(bufferSize);
        boolean cachedVertexData = false;
        boolean cachedNormalData = false;
        boolean cachedUvData = false;
        int vertexDataCacheHash = 0;
        int normalDataCacheHash = 0;
        int uvDataCacheHash = 0;
        if (!noCache) {
            FloatBuffer uvData;
            FloatBuffer normalData;
            vertexDataCacheHash = this.modelHasher.calculateVertexCacheHash();
            normalDataCacheHash = this.modelHasher.calculateNormalCacheHash();
            uvDataCacheHash = this.modelHasher.calculateUvCacheHash(modelOverride);
            IntBuffer vertexData = this.modelCache.getVertexData(vertexDataCacheHash);
            boolean bl = cachedVertexData = vertexData != null && vertexData.remaining() == bufferSize;
            if (cachedVertexData) {
                vertexLength = faceCount * 3;
                vertexBuffer.put(vertexData);
                vertexData.rewind();
            }
            boolean bl2 = cachedNormalData = (normalData = this.modelCache.getNormalData(normalDataCacheHash)) != null && normalData.remaining() == bufferSize;
            if (cachedNormalData) {
                normalBuffer.put(normalData);
                normalData.rewind();
            }
            boolean bl3 = cachedUvData = (uvData = this.modelCache.getUvData(uvDataCacheHash)) != null;
            if (cachedUvData) {
                uvLength = 3 * (uvData.remaining() / 12);
                uvBuffer.put(uvData);
                uvData.rewind();
            }
            if (cachedVertexData && cachedUvData && cachedNormalData) {
                ModelPusher.twoInts[0] = vertexLength;
                ModelPusher.twoInts[1] = uvLength;
                return twoInts;
            }
        }
        IntBuffer fullVertexData = null;
        FloatBuffer fullNormalData = null;
        FloatBuffer fullUvData = null;
        boolean bl = cachingVertexData = !cachedVertexData && !noCache;
        if (cachingVertexData && (fullVertexData = this.modelCache.takeIntBuffer(bufferSize)) == null) {
            log.error("failed to grab vertex buffer");
            cachingVertexData = false;
        }
        boolean bl4 = cachingNormalData = !cachedNormalData && !noCache;
        if (cachingNormalData && (fullNormalData = this.modelCache.takeFloatBuffer(bufferSize)) == null) {
            log.error("failed to grab normal buffer");
            cachingNormalData = false;
        }
        boolean bl5 = cachingUvData = !cachedUvData && !noCache;
        if (cachingUvData && (fullUvData = this.modelCache.takeFloatBuffer(bufferSize)) == null) {
            log.error("failed to grab uv buffer");
            cachingUvData = false;
        }
        boolean hideBakedEffects = this.config.hideBakedEffects();
        for (int face = 0; face < faceCount; ++face) {
            float[] tempUvData;
            if (!cachedVertexData) {
                int[] tempVertexData = this.getVertexDataForFace(model, this.getColorsForFace(hash, model, modelOverride, objectType, tileX, tileY, tileZ, face, hideBakedEffects), face);
                vertexBuffer.put(tempVertexData);
                vertexLength += 3;
                if (cachingVertexData) {
                    fullVertexData.put(tempVertexData);
                }
            }
            if (!cachedNormalData) {
                float[] tempNormalData = this.getNormalDataForFace(model, modelOverride, face);
                normalBuffer.put(tempNormalData);
                if (cachingNormalData) {
                    fullNormalData.put(tempNormalData);
                }
            }
            if (cachedUvData || (tempUvData = this.getUvDataForFace(model, modelOverride, face)) == null) continue;
            uvBuffer.put(tempUvData);
            uvLength += 3;
            if (!cachingUvData) continue;
            fullUvData.put(tempUvData);
        }
        if (cachingVertexData) {
            fullVertexData.flip();
            this.modelCache.putVertexData(vertexDataCacheHash, fullVertexData);
        }
        if (cachingNormalData) {
            fullNormalData.flip();
            this.modelCache.putNormalData(normalDataCacheHash, fullNormalData);
        }
        if (cachingUvData) {
            fullUvData.flip();
            this.modelCache.putUvData(uvDataCacheHash, fullUvData);
        }
        ModelPusher.twoInts[0] = vertexLength;
        ModelPusher.twoInts[1] = uvLength;
        return twoInts;
    }

    private int[] getVertexDataForFace(Model model, int[] faceColors, int face) {
        int[] xVertices = model.getVerticesX();
        int[] yVertices = model.getVerticesY();
        int[] zVertices = model.getVerticesZ();
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        ModelPusher.twelveInts[0] = xVertices[triA];
        ModelPusher.twelveInts[1] = yVertices[triA];
        ModelPusher.twelveInts[2] = zVertices[triA];
        ModelPusher.twelveInts[3] = faceColors[3] | faceColors[0];
        ModelPusher.twelveInts[4] = xVertices[triB];
        ModelPusher.twelveInts[5] = yVertices[triB];
        ModelPusher.twelveInts[6] = zVertices[triB];
        ModelPusher.twelveInts[7] = faceColors[3] | faceColors[1];
        ModelPusher.twelveInts[8] = xVertices[triC];
        ModelPusher.twelveInts[9] = yVertices[triC];
        ModelPusher.twelveInts[10] = zVertices[triC];
        ModelPusher.twelveInts[11] = faceColors[3] | faceColors[2];
        return twelveInts;
    }

    private float[] getNormalDataForFace(Model model, @NonNull ModelOverride modelOverride, int face) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        if (modelOverride.flatNormals || model.getFaceColors3()[face] == -1) {
            return zeroFloats;
        }
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        ModelPusher.twelveFloats[0] = xVertexNormals[triA];
        ModelPusher.twelveFloats[1] = yVertexNormals[triA];
        ModelPusher.twelveFloats[2] = zVertexNormals[triA];
        ModelPusher.twelveFloats[3] = 0.0f;
        ModelPusher.twelveFloats[4] = xVertexNormals[triB];
        ModelPusher.twelveFloats[5] = yVertexNormals[triB];
        ModelPusher.twelveFloats[6] = zVertexNormals[triB];
        ModelPusher.twelveFloats[7] = 0.0f;
        ModelPusher.twelveFloats[8] = xVertexNormals[triC];
        ModelPusher.twelveFloats[9] = yVertexNormals[triC];
        ModelPusher.twelveFloats[10] = zVertexNormals[triC];
        ModelPusher.twelveFloats[11] = 0.0f;
        return twelveFloats;
    }

    private float[] getUvDataForFace(Model model, @NonNull ModelOverride modelOverride, int face) {
        boolean isVanillaTextured;
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        short[] faceTextures = model.getFaceTextures();
        float[] uv = model.getFaceTextureUVCoordinates();
        Material material = Material.NONE;
        boolean bl = isVanillaTextured = faceTextures != null && uv != null && faceTextures[face] != -1;
        if (isVanillaTextured) {
            if (this.hdPlugin.configModelTextures) {
                material = modelOverride.textureMaterial;
            }
            if (material == Material.NONE) {
                material = Material.getTexture(faceTextures[face]);
            }
        } else if (this.hdPlugin.configModelTextures) {
            material = modelOverride.baseMaterial;
        }
        if (material == Material.NONE) {
            return faceTextures == null ? null : zeroFloats;
        }
        int packedMaterialData = this.packMaterialData(material, false);
        switch (modelOverride.uvType) {
            case GROUND_PLANE: {
                int triA = model.getFaceIndices1()[face];
                int triB = model.getFaceIndices2()[face];
                int triC = model.getFaceIndices3()[face];
                int[] xVertices = model.getVerticesX();
                int[] zVertices = model.getVerticesZ();
                ModelPusher.twelveFloats[0] = packedMaterialData;
                ModelPusher.twelveFloats[1] = (float)(xVertices[triA] % 128) / 128.0f;
                ModelPusher.twelveFloats[2] = (float)(zVertices[triA] % 128) / 128.0f;
                ModelPusher.twelveFloats[3] = 0.0f;
                ModelPusher.twelveFloats[4] = packedMaterialData;
                ModelPusher.twelveFloats[5] = (float)(xVertices[triB] % 128) / 128.0f;
                ModelPusher.twelveFloats[6] = (float)(zVertices[triB] % 128) / 128.0f;
                ModelPusher.twelveFloats[7] = 0.0f;
                ModelPusher.twelveFloats[8] = packedMaterialData;
                ModelPusher.twelveFloats[9] = (float)(xVertices[triC] % 128) / 128.0f;
                ModelPusher.twelveFloats[10] = (float)(zVertices[triC] % 128) / 128.0f;
                ModelPusher.twelveFloats[11] = 0.0f;
                break;
            }
            case VANILLA: {
                if (isVanillaTextured) {
                    int idx = face * 6;
                    ModelPusher.twelveFloats[0] = packedMaterialData;
                    ModelPusher.twelveFloats[1] = uv[idx];
                    ModelPusher.twelveFloats[2] = uv[idx + 1];
                    ModelPusher.twelveFloats[3] = 0.0f;
                    ModelPusher.twelveFloats[4] = packedMaterialData;
                    ModelPusher.twelveFloats[5] = uv[idx + 2];
                    ModelPusher.twelveFloats[6] = uv[idx + 3];
                    ModelPusher.twelveFloats[7] = 0.0f;
                    ModelPusher.twelveFloats[8] = packedMaterialData;
                    ModelPusher.twelveFloats[9] = uv[idx + 4];
                    ModelPusher.twelveFloats[10] = uv[idx + 5];
                    ModelPusher.twelveFloats[11] = 0.0f;
                    break;
                }
            }
            default: {
                ModelPusher.twelveFloats[0] = packedMaterialData;
                ModelPusher.twelveFloats[1] = 0.0f;
                ModelPusher.twelveFloats[2] = 0.0f;
                ModelPusher.twelveFloats[3] = 0.0f;
                ModelPusher.twelveFloats[4] = packedMaterialData;
                ModelPusher.twelveFloats[5] = 1.0f;
                ModelPusher.twelveFloats[6] = 0.0f;
                ModelPusher.twelveFloats[7] = 0.0f;
                ModelPusher.twelveFloats[8] = packedMaterialData;
                ModelPusher.twelveFloats[9] = 0.0f;
                ModelPusher.twelveFloats[10] = 1.0f;
                ModelPusher.twelveFloats[11] = 0.0f;
            }
        }
        return twelveFloats;
    }

    public int packMaterialData(Material material, boolean isOverlay) {
        return material.ordinal() << 1 | (isOverlay ? 1 : 0);
    }

    private boolean isBakedGroundShading(int face, int heightA, int heightB, int heightC, byte[] faceTransparencies, short[] faceTextures) {
        return faceTransparencies != null && heightA >= -8 && heightA == heightB && heightA == heightC && (faceTextures == null || faceTextures[face] == -1) && (faceTransparencies[face] & 0xFF) > 100;
    }

    private int[] getColorsForFace(long hash, Model model, @NonNull ModelOverride modelOverride, ObjectType objectType, int tileX, int tileY, int tileZ, int face, boolean hideBakedEffects) {
        if (modelOverride == null) {
            throw new NullPointerException("modelOverride is marked non-null but is null");
        }
        int triA = model.getFaceIndices1()[face];
        int triB = model.getFaceIndices2()[face];
        int triC = model.getFaceIndices3()[face];
        byte[] faceTransparencies = model.getFaceTransparencies();
        short[] faceTextures = model.getFaceTextures();
        int[] yVertices = model.getVerticesY();
        int heightA = yVertices[triA];
        int heightB = yVertices[triB];
        int heightC = yVertices[triC];
        if (hideBakedEffects && this.isBakedGroundShading(face, heightA, heightB, heightC, faceTransparencies, faceTextures)) {
            boolean removeBakedLighting = modelOverride.removeBakedLighting;
            if (ModelHash.getType(hash) == 0) {
                Player player;
                int index = ModelHash.getIdOrIndex(hash);
                Player[] players = this.client.getCachedPlayers();
                Player player2 = player = index >= 0 && index < players.length ? players[index] : null;
                if (player != null && player.getPlayerComposition().getEquipmentId(KitType.WEAPON) == 5614) {
                    removeBakedLighting = true;
                }
            }
            if (removeBakedLighting) {
                ModelPusher.fourInts[0] = 0;
                ModelPusher.fourInts[1] = 0;
                ModelPusher.fourInts[2] = 0;
                ModelPusher.fourInts[3] = -16777216;
                return fourInts;
            }
        }
        int color1 = model.getFaceColors1()[face];
        int color2 = model.getFaceColors2()[face];
        int color3 = model.getFaceColors3()[face];
        byte overrideAmount = model.getOverrideAmount();
        byte overrideHue = model.getOverrideHue();
        byte overrideSat = model.getOverrideSaturation();
        byte overrideLum = model.getOverrideLuminance();
        int[] xVertexNormals = model.getVertexNormalsX();
        int[] yVertexNormals = model.getVertexNormalsY();
        int[] zVertexNormals = model.getVertexNormalsZ();
        Tile tile = this.client.getScene().getTiles()[tileZ][tileX][tileY];
        if (color3 == -2) {
            ModelPusher.fourInts[0] = 0;
            ModelPusher.fourInts[1] = 0;
            ModelPusher.fourInts[2] = 0;
            ModelPusher.fourInts[3] = -16777216;
            return fourInts;
        }
        if (color3 == -1) {
            color2 = color3 = color1;
        } else if ((faceTextures == null || faceTextures[face] == -1) && overrideAmount > 0) {
            color1 = ModelPusher.interpolateHSL(color1, overrideHue, overrideSat, overrideLum, overrideAmount);
            color2 = ModelPusher.interpolateHSL(color2, overrideHue, overrideSat, overrideLum, overrideAmount);
            color3 = ModelPusher.interpolateHSL(color3, overrideHue, overrideSat, overrideLum, overrideAmount);
        }
        int color1H = color1 >> 10 & 0x3F;
        int color1S = color1 >> 7 & 7;
        int color1L = color1 & 0x7F;
        int color2H = color2 >> 10 & 0x3F;
        int color2S = color2 >> 7 & 7;
        int color2L = color2 & 0x7F;
        int color3H = color3 >> 10 & 0x3F;
        int color3S = color3 >> 7 & 7;
        int color3L = color3 & 0x7F;
        int lightenA = (int)((float)Math.max(color1L - 3, 0) * 3.0f) + 10;
        float dotA = Math.max(HDUtils.dotNormal3Lights(new float[]{xVertexNormals[triA], yVertexNormals[triA], zVertexNormals[triA]}), 0.0f);
        color1L = (int)HDUtils.lerp(color1L, lightenA, dotA);
        int lightenB = (int)((float)Math.max(color2L - 3, 0) * 3.0f) + 10;
        float dotB = Math.max(HDUtils.dotNormal3Lights(new float[]{xVertexNormals[triB], yVertexNormals[triB], zVertexNormals[triB]}), 0.0f);
        color2L = (int)HDUtils.lerp(color2L, lightenB, dotB);
        int lightenC = (int)((float)Math.max(color3L - 3, 0) * 3.0f) + 10;
        float dotC = Math.max(HDUtils.dotNormal3Lights(new float[]{xVertexNormals[triC], yVertexNormals[triC], zVertexNormals[triC]}), 0.0f);
        color3L = (int)HDUtils.lerp(color3L, lightenC, dotC);
        int maxBrightness1 = (int)HDUtils.lerp(127.0f, 55.0f, (float)Math.pow((float)color1S / 7.0f, 0.05));
        int maxBrightness2 = (int)HDUtils.lerp(127.0f, 55.0f, (float)Math.pow((float)color2S / 7.0f, 0.05));
        int maxBrightness3 = (int)HDUtils.lerp(127.0f, 55.0f, (float)Math.pow((float)color3S / 7.0f, 0.05));
        if (faceTextures != null && faceTextures[face] != -1) {
            color3H = 0;
            color2H = 0;
            color1H = 0;
            color3S = 0;
            color2S = 0;
            color1S = 0;
            color3L = 127;
            color2L = 127;
            color1L = 127;
            maxBrightness3 = 90;
            maxBrightness2 = 90;
            maxBrightness1 = 90;
        }
        if (tile != null && modelOverride.inheritTileColorType != InheritTileColorType.NONE) {
            SceneTileModel tileModel = tile.getSceneTileModel();
            SceneTilePaint tilePaint = tile.getSceneTilePaint();
            if (tilePaint != null || tileModel != null) {
                if (tilePaint != null && tilePaint.getTexture() == -1 && tilePaint.getRBG() != 0) {
                    int[] tileColorHSL = HDUtils.colorIntToHSL(tilePaint.getSwColor());
                    tileColorHSL[1] = (tileColorHSL[1] + HDUtils.colorIntToHSL(tilePaint.getSeColor())[1] + HDUtils.colorIntToHSL(tilePaint.getNwColor())[1] + HDUtils.colorIntToHSL(tilePaint.getNeColor())[1]) / 4;
                    tileColorHSL[2] = (tileColorHSL[2] + HDUtils.colorIntToHSL(tilePaint.getSeColor())[2] + HDUtils.colorIntToHSL(tilePaint.getNwColor())[2] + HDUtils.colorIntToHSL(tilePaint.getNeColor())[2]) / 4;
                    Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                    Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                    tileColorHSL = overlay != Overlay.NONE ? this.proceduralGenerator.recolorOverlay(overlay, tileColorHSL) : this.proceduralGenerator.recolorUnderlay(underlay, tileColorHSL);
                    color2H = color3H = tileColorHSL[0];
                    color1H = color3H;
                    color2S = color3S = tileColorHSL[1];
                    color1S = color3S;
                    color2L = color3L = tileColorHSL[2];
                    color1L = color3L;
                } else if (tileModel != null && tileModel.getTriangleTextureId() == null) {
                    int faceColorIndex = -1;
                    for (int i = 0; i < tileModel.getTriangleColorA().length; ++i) {
                        boolean isOverlayFace = this.proceduralGenerator.isOverlayFace(tile, i);
                        if (modelOverride.inheritTileColorType == InheritTileColorType.UNDERLAY || tileModel.getModelOverlay() == 0) {
                            if (isOverlayFace) continue;
                            faceColorIndex = i;
                            break;
                        }
                        if (modelOverride.inheritTileColorType != InheritTileColorType.OVERLAY || !isOverlayFace) continue;
                        faceColorIndex = i;
                        break;
                    }
                    if (faceColorIndex != -1) {
                        int[] tileColorHSL = HDUtils.colorIntToHSL(tileModel.getTriangleColorA()[faceColorIndex]);
                        Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                        tileColorHSL = this.proceduralGenerator.recolorUnderlay(underlay, tileColorHSL);
                        color2H = color3H = tileColorHSL[0];
                        color1H = color3H;
                        color2S = color3S = tileColorHSL[1];
                        color1S = color3S;
                        color2L = color3L = tileColorHSL[2];
                        color1L = color3L;
                    }
                }
            }
        }
        int packedAlphaPriority = this.getPackedAlphaPriority(model, face);
        if (this.hdPlugin.configTzhaarHD && modelOverride.tzHaarRecolorType != TzHaarRecolorType.NONE) {
            int[][] tzHaarRecolored = this.proceduralGenerator.recolorTzHaar(modelOverride, heightA, heightB, heightC, packedAlphaPriority, objectType, color1S, color1L, color2S, color2L, color3S, color3L);
            color1H = tzHaarRecolored[0][0];
            color1S = tzHaarRecolored[0][1];
            color1L = tzHaarRecolored[0][2];
            color2H = tzHaarRecolored[1][0];
            color2S = tzHaarRecolored[1][1];
            color2L = tzHaarRecolored[1][2];
            color3H = tzHaarRecolored[2][0];
            color3S = tzHaarRecolored[2][1];
            color3L = tzHaarRecolored[2][2];
            packedAlphaPriority = tzHaarRecolored[3][0];
        }
        color1L = HDUtils.clamp(color1L, 0, maxBrightness1);
        color2L = HDUtils.clamp(color2L, 0, maxBrightness2);
        color3L = HDUtils.clamp(color3L, 0, maxBrightness3);
        color1 = (color1H << 3 | color1S) << 7 | color1L;
        color2 = (color2H << 3 | color2S) << 7 | color2L;
        color3 = (color3H << 3 | color3S) << 7 | color3L;
        ModelPusher.fourInts[0] = color1;
        ModelPusher.fourInts[1] = color2;
        ModelPusher.fourInts[2] = color3;
        ModelPusher.fourInts[3] = packedAlphaPriority;
        return fourInts;
    }

    private static int interpolateHSL(int hsl, byte hue2, byte sat2, byte lum2, byte lerp) {
        int hue = hsl >> 10 & 0x3F;
        int sat = hsl >> 7 & 7;
        int lum = hsl & 0x7F;
        int var9 = lerp & 0xFF;
        if (hue2 != -1) {
            hue += var9 * (hue2 - hue) >> 7;
        }
        if (sat2 != -1) {
            sat += var9 * (sat2 - sat) >> 7;
        }
        if (lum2 != -1) {
            lum += var9 * (lum2 - lum) >> 7;
        }
        return (hue << 10 | sat << 7 | lum) & 0xFFFF;
    }

    private int getPackedAlphaPriority(Model model, int face) {
        short[] faceTextures = model.getFaceTextures();
        byte[] faceTransparencies = model.getFaceTransparencies();
        byte[] facePriorities = model.getFaceRenderPriorities();
        int alpha = 0;
        if (faceTransparencies != null && (faceTextures == null || faceTextures[face] == -1)) {
            alpha = (faceTransparencies[face] & 0xFF) << 24;
        }
        int priority = 0;
        if (facePriorities != null) {
            priority = (facePriorities[face] & 0xFF) << 16;
        }
        return alpha | priority;
    }
}

