/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.model;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.model.BufferPool;
import rs117.hd.model.FloatBufferCache;
import rs117.hd.model.IntBufferCache;

public class ModelCache {
    private static final Logger log = LoggerFactory.getLogger(ModelCache.class);
    private BufferPool bufferPool;
    private IntBufferCache vertexDataCache;
    private FloatBufferCache normalDataCache;
    private FloatBufferCache uvDataCache;

    public void init(HdPlugin hdPlugin, HdPluginConfig config) {
        int modelCacheSizeMiB = config.modelCacheSizeMiB();
        if (!Objects.equals(System.getProperty("sun.arch.data.model"), "64") && modelCacheSizeMiB > 1024) {
            log.error("defaulting model cache to 1024MiB due to non 64-bit client");
            modelCacheSizeMiB = 1024;
        }
        try {
            long totalPhysicalMemoryMiB = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 1024L / 1024L;
            if ((long)modelCacheSizeMiB > totalPhysicalMemoryMiB / 2L) {
                modelCacheSizeMiB = (int)(totalPhysicalMemoryMiB / 2L);
                log.error("limiting the cache to " + modelCacheSizeMiB + " since the selected amount exceeds half of the total physical memory for the system.");
            }
        }
        catch (Throwable e) {
            log.error("failed to check physical memory size: " + String.valueOf(e));
        }
        this.bufferPool = new BufferPool((long)modelCacheSizeMiB * 0x100000L, hdPlugin);
        this.bufferPool.allocate();
        this.vertexDataCache = new IntBufferCache(this.bufferPool);
        this.normalDataCache = new FloatBufferCache(this.bufferPool);
        this.uvDataCache = new FloatBufferCache(this.bufferPool);
    }

    public void shutDown() {
        this.clear();
        if (this.bufferPool != null) {
            this.bufferPool.free();
        }
    }

    public IntBuffer getVertexData(int hash) {
        return (IntBuffer)this.vertexDataCache.get(hash);
    }

    public void putVertexData(int hash, IntBuffer data) {
        this.vertexDataCache.put(hash, data);
    }

    public FloatBuffer getNormalData(int hash) {
        return (FloatBuffer)this.normalDataCache.get(hash);
    }

    public void putNormalData(int hash, FloatBuffer data) {
        this.normalDataCache.put(hash, data);
    }

    public FloatBuffer getUvData(int hash) {
        return (FloatBuffer)this.uvDataCache.get(hash);
    }

    public void putUvData(int hash, FloatBuffer data) {
        this.uvDataCache.put(hash, data);
    }

    public IntBuffer takeIntBuffer(int capacity) {
        if (this.bufferPool.isEmpty() && !this.makeRoom()) {
            log.error("failed to make room for int buffer");
        }
        return this.bufferPool.takeIntBuffer(capacity);
    }

    public FloatBuffer takeFloatBuffer(int capacity) {
        if (this.bufferPool.isEmpty() && !this.makeRoom()) {
            log.error("failed to make room for float buffer");
        }
        return this.bufferPool.takeFloatBuffer(capacity);
    }

    public boolean makeRoom() {
        if (this.uvDataCache.size() * 16 > this.normalDataCache.size() && this.normalDataCache.size() > 0) {
            return this.uvDataCache.makeRoom();
        }
        if (this.normalDataCache.size() * 2 > this.vertexDataCache.size()) {
            return this.normalDataCache.makeRoom();
        }
        return this.vertexDataCache.makeRoom();
    }

    public void clear() {
        if (this.vertexDataCache != null) {
            this.vertexDataCache.clear();
        }
        if (this.normalDataCache != null) {
            this.normalDataCache.clear();
        }
        if (this.uvDataCache != null) {
            this.uvDataCache.clear();
        }
    }
}

