/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.border.BorderWrapper;

public class LockBorder
implements Border,
UIResource,
BorderWrapper {
    private Border originalBorder;

    public LockBorder(Border originalBorder) {
        this.originalBorder = originalBorder != null ? originalBorder : new EmptyBorder(0, 0, 0, 0);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Icon lockIcon = SubstanceImageCreator.getSmallLockIcon(SubstanceColorSchemeUtilities.getColorScheme(c, ComponentState.ENABLED), c);
        Insets origInsets = this.originalBorder.getBorderInsets(c);
        if (c.getComponentOrientation().isLeftToRight()) {
            return new Insets(origInsets.top, origInsets.left, origInsets.bottom, Math.max(origInsets.right, lockIcon.getIconWidth() + 2));
        }
        return new Insets(origInsets.top, Math.max(origInsets.left, lockIcon.getIconWidth() + 2), origInsets.bottom, origInsets.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return this.originalBorder.isBorderOpaque();
    }

    @Override
    public Border getOriginalBorder() {
        return this.originalBorder;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        this.originalBorder.paintBorder(c, g2, x, y, width, height);
        Icon lockIcon = SubstanceImageCreator.getSmallLockIcon(SubstanceColorSchemeUtilities.getColorScheme(c, ComponentState.ENABLED), c);
        int offsetY = 1;
        if (c.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)c.getParent();
            if (viewport.getScrollMode() != 0) {
                viewport.setScrollMode(0);
            }
            Rectangle viewRect = viewport.getViewRect();
            offsetY = c.getHeight() - viewRect.y - viewRect.height;
        }
        int iconY = y + height - lockIcon.getIconHeight() - offsetY;
        if (c.getComponentOrientation().isLeftToRight()) {
            lockIcon.paintIcon(c, g2, x + width - lockIcon.getIconWidth(), iconY);
        } else {
            lockIcon.paintIcon(c, g2, x, iconY);
        }
    }
}

