/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.intellij;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import org.pushingpixels.substance.api.icon.IsHiDpiAware;
import org.pushingpixels.substance.internal.contrib.intellij.HiDPIScaledGraphics;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;

public class JBHiDPIScaledImage
extends BufferedImage
implements IsHiDpiAware {
    private final Image myImage;
    private int myWidth;
    private int myHeight;
    private boolean ignoreScaling;

    public JBHiDPIScaledImage(int width, int height, int type) {
        this(null, (int)(UIUtil.getScaleFactor() * (double)width), (int)(UIUtil.getScaleFactor() * (double)height), type);
    }

    public JBHiDPIScaledImage(Image image, int width, int height, int type) {
        super(image != null ? 1 : width, image != null ? 1 : height, type);
        this.myImage = image;
        this.myWidth = width;
        this.myHeight = height;
    }

    public JBHiDPIScaledImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties, int width, int height) {
        super(cm, raster, isRasterPremultiplied, properties);
        this.myImage = null;
        this.myWidth = width;
        this.myHeight = height;
    }

    public void setIgnoreScaling() {
        this.ignoreScaling = true;
    }

    @Override
    public boolean isHiDpiAware() {
        return true;
    }

    public Image getDelegate() {
        return this.myImage;
    }

    @Override
    public int getWidth() {
        return this.myImage != null ? this.myWidth : super.getWidth();
    }

    @Override
    public int getHeight() {
        return this.myImage != null ? this.myHeight : super.getHeight();
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.myImage != null ? this.myWidth : super.getWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.myImage != null ? this.myHeight : super.getHeight(observer);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g2 = super.createGraphics();
        if (this.myImage == null) {
            if (!this.ignoreScaling) {
                double scaleFactor = UIUtil.getScaleFactor();
                g2.scale(scaleFactor, scaleFactor);
            }
            return new HiDPIScaledGraphics(g2);
        }
        return g2;
    }
}

