/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.menus;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerMenuOptionsChanged;
import net.runelite.api.events.WidgetMenuOptionClicked;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.menus.WidgetMenuOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MenuManager {
    private static final Logger log = LoggerFactory.getLogger(MenuManager.class);
    private static final int IDX_LOWER = 4;
    private static final int IDX_UPPER = 8;
    private final Client client;
    private final EventBus eventBus;
    private final Map<Integer, String> playerMenuIndexMap = new HashMap<Integer, String>();
    private final Multimap<Integer, WidgetMenuOption> managedMenuOptions = LinkedHashMultimap.create();

    @Inject
    private MenuManager(Client client, EventBus eventBus) {
        this.client = client;
        this.eventBus = eventBus;
        eventBus.register(this);
    }

    public void addManagedCustomMenu(WidgetMenuOption customMenuOption, Consumer<MenuEntry> callback) {
        this.managedMenuOptions.put(customMenuOption.getWidgetId(), customMenuOption);
        customMenuOption.callback = callback;
    }

    public void removeManagedCustomMenu(WidgetMenuOption customMenuOption) {
        this.managedMenuOptions.remove(customMenuOption.getWidgetId(), customMenuOption);
    }

    private static boolean menuContainsCustomMenu(MenuEntry[] menuEntries, WidgetMenuOption customMenuOption) {
        for (MenuEntry menuEntry : menuEntries) {
            String option = menuEntry.getOption();
            String target = menuEntry.getTarget();
            if (!option.equals(customMenuOption.getMenuOption()) || !target.equals(customMenuOption.getMenuTarget())) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.client.getSpellSelected() || event.getType() != MenuAction.CC_OP.getId()) {
            return;
        }
        int widgetId = event.getActionParam1();
        Collection<WidgetMenuOption> options = this.managedMenuOptions.get(widgetId);
        if (options.isEmpty()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int insertIdx = -1;
        for (WidgetMenuOption currentMenu : options) {
            if (MenuManager.menuContainsCustomMenu(menuEntries, currentMenu)) {
                return;
            }
            this.client.createMenuEntry(insertIdx--).setOption(currentMenu.getMenuOption()).setTarget(currentMenu.getMenuTarget()).setType(MenuAction.RUNELITE).setParam1(widgetId).onClick(currentMenu.callback);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE) {
            return;
        }
        int widgetId = event.getParam1();
        Collection<WidgetMenuOption> options = this.managedMenuOptions.get(widgetId);
        for (WidgetMenuOption curMenuOption : options) {
            if (!curMenuOption.getMenuTarget().equals(event.getMenuTarget()) || !curMenuOption.getMenuOption().equals(event.getMenuOption())) continue;
            WidgetMenuOptionClicked widgetMenuOptionClicked = new WidgetMenuOptionClicked();
            widgetMenuOptionClicked.setMenuOption(event.getMenuOption());
            widgetMenuOptionClicked.setMenuTarget(event.getMenuTarget());
            widgetMenuOptionClicked.setWidget(curMenuOption.getWidget());
            widgetMenuOptionClicked.setWidgetId(curMenuOption.getWidgetId());
            this.eventBus.post(widgetMenuOptionClicked);
            return;
        }
    }

    public void addPlayerMenuItem(String menuText) {
        Preconditions.checkNotNull(menuText);
        int playerMenuIndex = this.findEmptyPlayerMenuIndex();
        if (playerMenuIndex == 8) {
            return;
        }
        this.addPlayerMenuItem(playerMenuIndex, menuText);
    }

    public void removePlayerMenuItem(String menuText) {
        Preconditions.checkNotNull(menuText);
        for (Map.Entry<Integer, String> entry : this.playerMenuIndexMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(menuText)) continue;
            this.removePlayerMenuItem(entry.getKey());
            break;
        }
    }

    @Subscribe
    public void onPlayerMenuOptionsChanged(PlayerMenuOptionsChanged event) {
        int idx = event.getIndex();
        String menuText = this.playerMenuIndexMap.get(idx);
        if (menuText == null) {
            return;
        }
        int newIdx = this.findEmptyPlayerMenuIndex();
        if (newIdx == 8) {
            log.debug("Client has updated player menu index {} where option {} was, and there are no more free slots available", (Object)idx, (Object)menuText);
            return;
        }
        log.debug("Client has updated player menu index {} where option {} was, moving to index {}", idx, menuText, newIdx);
        this.playerMenuIndexMap.remove(idx);
        this.addPlayerMenuItem(newIdx, menuText);
    }

    private void addPlayerMenuItem(int playerOptionIndex, String menuText) {
        this.client.getPlayerOptions()[playerOptionIndex] = menuText;
        this.client.getPlayerOptionsPriorities()[playerOptionIndex] = true;
        this.client.getPlayerMenuTypes()[playerOptionIndex] = MenuAction.RUNELITE_PLAYER.getId();
        this.playerMenuIndexMap.put(playerOptionIndex, menuText);
    }

    private void removePlayerMenuItem(int playerOptionIndex) {
        this.client.getPlayerOptions()[playerOptionIndex] = null;
        this.playerMenuIndexMap.remove(playerOptionIndex);
    }

    private int findEmptyPlayerMenuIndex() {
        int index;
        String[] playerOptions = this.client.getPlayerOptions();
        for (index = 4; index < 8 && playerOptions[index] != null; ++index) {
        }
        return index;
    }
}

