/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper;

import com.zulrahhelper.Phase;
import com.zulrahhelper.options.Attack;
import com.zulrahhelper.options.OverheadProtection;

public class PhaseBuilder {
    private int number;
    private Phase.Rotation rotation;
    private Attack[] attacks = new Attack[]{Attack.NONE, Attack.NONE, Attack.NONE};
    private OverheadProtection[] prayers = new OverheadProtection[]{OverheadProtection.NONE, OverheadProtection.NONE};

    public Phase build() {
        return new Phase(this.rotation, this.number, this.prayers, this.attacks);
    }

    public PhaseBuilder setRotation(Phase.Rotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public PhaseBuilder setNumber(int number) {
        this.number = number;
        return this;
    }

    public PhaseBuilder addAttack(Attack attack) {
        switch (attack.getSource()) {
            case NORMAL: {
                this.attacks[0] = attack;
                break;
            }
            case VENOM: {
                this.attacks[1] = attack;
                break;
            }
            case SNAKELING: {
                this.attacks[2] = attack;
            }
        }
        return this;
    }

    public PhaseBuilder setRangedPray() {
        this.setPrayer(OverheadProtection.PROTECT_FROM_MISSILES);
        return this;
    }

    public PhaseBuilder setMagePray() {
        this.setPrayer(OverheadProtection.PROTECT_FROM_MAGIC);
        return this;
    }

    private void setPrayer(OverheadProtection protect) {
        if (this.prayers[0] == OverheadProtection.NONE) {
            this.prayers[0] = protect;
        } else {
            this.prayers[1] = protect;
        }
    }
}

