/*
 * Decompiled with CFR 0.152.
 */
package com.visualmetronome;

import com.visualmetronome.FontTypes;
import com.visualmetronome.VisualMetronomeConfig;
import com.visualmetronome.VisualMetronomePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class VisualMetronomeTileOverlay
extends Overlay {
    private final Client client;
    private final VisualMetronomeConfig config;
    private final VisualMetronomePlugin plugin;

    @Inject
    public VisualMetronomeTileOverlay(Client client, VisualMetronomeConfig config, VisualMetronomePlugin plugin) {
        super(plugin);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPriority(OverlayPriority.MED);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.highlightCurrentTile()) {
            WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
            if (playerPos == null) {
                return null;
            }
            LocalPoint playerPosLocal = LocalPoint.fromWorld(this.client, playerPos);
            if (playerPosLocal == null) {
                return null;
            }
            if (this.config.changeFillColor()) {
                Color fillColor = new Color(this.plugin.currentColor.getRed(), this.plugin.currentColor.getGreen(), this.plugin.currentColor.getBlue(), this.config.changeFillColorOpacity());
                this.renderTile(graphics, playerPosLocal, this.plugin.currentColor, fillColor, this.config.currentTileBorderWidth());
            } else {
                this.renderTile(graphics, playerPosLocal, this.plugin.currentColor, this.config.currentTileFillColor(), this.config.currentTileBorderWidth());
            }
        }
        if (this.config.showPlayerTick()) {
            if (this.config.fontType() == FontTypes.REGULAR) {
                graphics.setFont(new Font(FontManager.getRunescapeFont().getName(), 0, this.config.fontSize()));
            } else {
                graphics.setFont(new Font(this.config.fontType().toString(), 0, this.config.fontSize()));
            }
            int height = this.client.getLocalPlayer().getLogicalHeight() + 20;
            LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
            Point playerPoint = Perspective.localToCanvas(this.client, localLocation, this.client.getPlane(), height);
            if (this.config.tickCount() == 1) {
                OverlayUtil.renderTextLocation(graphics, playerPoint, String.valueOf(this.plugin.currentColorIndex), this.config.NumberColor());
            } else {
                OverlayUtil.renderTextLocation(graphics, playerPoint, String.valueOf(this.plugin.tickCounter), this.config.NumberColor());
            }
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color, Color fillColor, double borderWidth) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly(this.client, dest);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon(graphics, poly, color, fillColor, new BasicStroke((float)borderWidth));
    }
}

