/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.timetracking;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.timetracking.Split;
import com.duckblade.osrs.toa.features.timetracking.SplitsMode;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SplitsTracker
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(SplitsTracker.class);
    private static final String ROOM_COMPLETE_PREFIX = "Challenge complete";
    private static final Pattern ROOM_COMPLETE_PATTERN = Pattern.compile("Challenge complete: (?:Path of )?([A-Za-z-]+).*Total:.*?([0-9]+:[.0-9]+).*");
    private static final Pattern WARDENS_COMPLETE_PATTERN = Pattern.compile("Challenge complete: The (Wardens).*?completion time:.*?([0-9]+:[.0-9]+).*");
    private final EventBus eventBus;
    private final TombsOfAmascutConfig config;
    private final Client client;
    private final List<Split> splits = new ArrayList<Split>(9);

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.isInRaid();
    }

    @Override
    public void startUp() {
        this.splits.clear();
        this.eventBus.register(this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String msg = e.getMessage();
        if (!msg.startsWith(ROOM_COMPLETE_PREFIX)) {
            return;
        }
        Matcher m3 = WARDENS_COMPLETE_PATTERN.matcher(msg);
        if (!m3.matches() && !(m3 = ROOM_COMPLETE_PATTERN.matcher(msg)).matches()) {
            return;
        }
        RaidRoom room = RaidRoom.forString(m3.group(1));
        String split = m3.group(2);
        if (room == null) {
            log.warn("Failed to find room {} for completion string {}", (Object)m3.group(1), (Object)e.getMessage());
            return;
        }
        this.splits.add(new Split(room, split));
        if (room == RaidRoom.WARDENS && this.config.splitsMessage() != SplitsMode.OFF) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.buildSplitsMessages(), "", false);
        }
    }

    public List<Split> getSplits() {
        return Collections.unmodifiableList(this.splits);
    }

    private String buildSplitsMessages() {
        SplitsMode splitsMode = this.config.splitsMessage();
        StringBuilder sb = new StringBuilder();
        sb.append("ToA Splits<br>");
        for (Split s2 : this.getSplits()) {
            if (!splitsMode.includesRoom(s2.getRoom())) continue;
            sb.append((Object)s2.getRoom());
            sb.append(": ");
            sb.append(ColorUtil.wrapWithColorTag(s2.getSplit(), Color.red));
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Inject
    public SplitsTracker(EventBus eventBus, TombsOfAmascutConfig config, Client client) {
        this.eventBus = eventBus;
        this.config = config;
        this.client = client;
    }
}

