/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.pickaxe;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.het.pickaxe.PickaxeUtil;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class DepositPickaxePreventEntry
implements PluginLifecycleComponent {
    private final EventBus eventBus;
    private final Client client;
    private final RaidStateTracker raidStateTracker;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState currentState) {
        return currentState.getCurrentRoom() == RaidRoom.HET && config.hetPickaxePreventExit() || currentState.isInLobby() && config.hetPickaxePreventRaidStart();
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        if (this.raidStateTracker.getCurrentState().isInLobby()) {
            if (!PickaxeUtil.pickaxeIsInStorage(this.client) && DepositPickaxePreventEntry.isEntry(e.getMenuEntry())) {
                e.getMenuEntry().setDeprioritized(true);
            }
        } else if (this.raidStateTracker.getCurrentState().getCurrentRoom() == RaidRoom.HET && DepositPickaxePreventEntry.isEntry(e.getMenuEntry()) && PickaxeUtil.hasPickaxe(this.client)) {
            e.getMenuEntry().setDeprioritized(true);
        }
    }

    private static boolean isEntry(MenuEntry menuEntry) {
        return menuEntry.getOption().contains("Enter") && menuEntry.getTarget().contains("Entry");
    }

    @Inject
    public DepositPickaxePreventEntry(EventBus eventBus, Client client, RaidStateTracker raidStateTracker) {
        this.eventBus = eventBus;
        this.client = client;
        this.raidStateTracker = raidStateTracker;
    }
}

